/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.trace;

import com.yahoo.yolean.trace.TraceVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class TraceNode {
    private final Object payload;
    private final long timestamp;
    private List<TraceNode> children;
    private TraceNode parent;

    public TraceNode(Object payload, long timestamp) {
        this.payload = payload;
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceNode add(TraceNode child) {
        if (child.parent != null) {
            throw new IllegalArgumentException("Can not add " + child + " to " + this + "; it is not a root.");
        }
        child.parent = this;
        TraceNode traceNode = this;
        synchronized (traceNode) {
            if (this.children == null) {
                this.children = Collections.synchronizedList(new ArrayList());
            }
        }
        this.children.add(child);
        return this;
    }

    public <PAYLOADTYPE> Iterable<PAYLOADTYPE> descendants(final Class<PAYLOADTYPE> payloadType) {
        if (this.children == null) {
            return List.of();
        }
        return new Iterable<PAYLOADTYPE>(){

            @Override
            public Iterator<PAYLOADTYPE> iterator() {
                return new PayloadIterator(TraceNode.this, payloadType);
            }
        };
    }

    public Object payload() {
        return this.payload;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public TraceNode parent() {
        return this.parent;
    }

    public Iterable<TraceNode> children() {
        if (this.children == null) {
            return List.of();
        }
        return this.children;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TraceNode root() {
        TraceNode node = this;
        while (node.parent != null) {
            node = node.parent;
        }
        return node;
    }

    public <T extends TraceVisitor> T accept(T visitor) {
        visitor.visit(this);
        if (this.children == null || this.children.isEmpty()) {
            return visitor;
        }
        visitor.entering(this);
        for (TraceNode child : this.children) {
            child.accept(visitor);
        }
        visitor.leaving(this);
        return visitor;
    }

    public String toString() {
        final StringBuilder out = new StringBuilder("[ ");
        this.accept(new TraceVisitor(){

            @Override
            public void visit(TraceNode node) {
                if (node.payload != null) {
                    out.append(node.payload).append(" ");
                }
            }

            @Override
            public void entering(TraceNode node) {
                out.append("[ ");
            }

            @Override
            public void leaving(TraceNode node) {
                out.append("] ");
            }
        });
        return out.append("]").toString();
    }

    private static class PayloadIterator<PAYLOADTYPE>
    implements Iterator<PAYLOADTYPE> {
        final List<TraceNode> unexploredNodes = new LinkedList<TraceNode>();
        final Class<PAYLOADTYPE> payloadType;
        PAYLOADTYPE next;

        PayloadIterator(TraceNode root, Class<PAYLOADTYPE> payloadType) {
            payloadType.getClass();
            this.payloadType = payloadType;
            this.unexploredNodes.add(root);
            this.next = this.advance();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public PAYLOADTYPE next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            PAYLOADTYPE current = this.next;
            this.next = this.advance();
            return current;
        }

        PAYLOADTYPE advance() {
            while (this.unexploredNodes.size() > 0) {
                Object payload;
                TraceNode node = this.unexploredNodes.remove(0);
                if (node.children != null) {
                    int i = 0;
                    for (TraceNode child : node.children) {
                        this.unexploredNodes.add(i++, child);
                    }
                }
                if (!this.payloadType.isInstance(payload = node.payload())) continue;
                return this.payloadType.cast(payload);
            }
            return null;
        }
    }
}

