/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.yahoo.tensor.impl.Convert;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Label {
    private static final String[] SMALL_INDEXES = Label.createSmallIndexesAsStrings(1000);
    private static final Map<String, Long> string2Enum = new ConcurrentHashMap<String, Long>();
    private static volatile String[] uniqueStrings = new String[]{"UNIQUE_UNUSED_MAGIC", "Tensor.INVALID_INDEX"};
    private static int numUniqeStrings = 2;

    private static String[] createSmallIndexesAsStrings(int count) {
        String[] asStrings = new String[count];
        for (int i = 0; i < count; ++i) {
            asStrings[i] = String.valueOf(i);
        }
        return asStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long addNewUniqueString(String s) {
        Map<String, Long> map = string2Enum;
        synchronized (map) {
            if (numUniqeStrings >= uniqueStrings.length) {
                uniqueStrings = Arrays.copyOf(uniqueStrings, uniqueStrings.length * 2);
            }
            Label.uniqueStrings[Label.numUniqeStrings] = s;
            return -numUniqeStrings++;
        }
    }

    private static String asNumericString(long index) {
        return index >= 0L && index < (long)SMALL_INDEXES.length ? SMALL_INDEXES[(int)index] : String.valueOf(index);
    }

    private static boolean validNumericIndex(String s) {
        if (s.isEmpty() || s.length() > 1 && s.charAt(0) == '0') {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static long toNumber(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            if (Label.validNumericIndex(s)) {
                return Long.parseLong(s, 10);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string2Enum.computeIfAbsent(s, Label::addNewUniqueString);
    }

    public static String fromNumber(long v) {
        if (v >= 0L) {
            return Label.asNumericString(v);
        }
        if (v == -1L) {
            return null;
        }
        int index = -Convert.safe2Int(v);
        return uniqueStrings[index];
    }
}

