/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import com.yahoo.concurrent.Timer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum SystemTimer implements Timer
{
    INSTANCE;

    private volatile long millis;

    public static long detectHz() {
        Logger log = Logger.getLogger(SystemTimer.class.getName());
        String hzEnv = System.getenv("VESPA_TIMER_HZ");
        long hz = 1000L;
        if (hzEnv != null && !hzEnv.isBlank()) {
            try {
                hz = Integer.parseInt(hzEnv);
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Failed parsing VESPA_TIMER_HZ='" + hzEnv + "'", e);
            }
        }
        hz = Math.min(1000L, Math.max(1L, hz));
        log.fine("vespa-system-timer running at " + hz + "hz. VESPA_TIMER_HZ='" + hzEnv + "'");
        return hz;
    }

    public static Duration adjustTimeoutByDetectedHz(Duration timeout) {
        return SystemTimer.adjustTimeoutByDetectedHz(timeout, SystemTimer.detectHz());
    }

    public static Duration adjustTimeoutByDetectedHz(Duration timeout, long hz) {
        return timeout.multipliedBy(1000L).dividedBy(hz);
    }

    private SystemTimer() {
        long napTime = SystemTimer.adjustTimeoutByDetectedHz(Duration.ofMillis(1L)).toMillis();
        long creationNanos = System.nanoTime();
        this.millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - creationNanos);
        Thread thread = new Thread(() -> {
            while (true) {
                this.millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - creationNanos);
                try {
                    Thread.sleep(napTime);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("vespa-system-timer");
        thread.start();
    }

    @Override
    public long milliTime() {
        return this.millis;
    }
}

