/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.Optional;

public class Optionals {
    private Optionals() {
    }

    @SafeVarargs
    public static <T> Optional<T> firstNonEmpty(Optional<T> ... optionals) {
        for (Optional<T> optional : optionals) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Optional<T> min(Optional<T> ... optionals) {
        Optional best = Optional.empty();
        for (Optional<T> optional : optionals) {
            if (!best.isEmpty() && (!optional.isPresent() || ((Comparable)optional.get()).compareTo((Comparable)best.get()) >= 0)) continue;
            best = optional;
        }
        return best;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Optional<T> max(Optional<T> ... optionals) {
        Optional best = Optional.empty();
        for (Optional<T> optional : optionals) {
            if (!best.isEmpty() && (!optional.isPresent() || ((Comparable)optional.get()).compareTo((Comparable)best.get()) <= 0)) continue;
            best = optional;
        }
        return best;
    }

    public static <T> boolean equalIfBothPresent(Optional<T> first, Optional<T> second) {
        return first.isEmpty() || second.isEmpty() || first.equals(second);
    }

    public static <T> boolean emptyOrEqual(Optional<T> optional, T value) {
        return optional.isEmpty() || optional.equals(Optional.of(value));
    }
}

