/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.validation;

import com.yahoo.yolean.Exceptions;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;

public class Validation {
    private Validation() {
    }

    public static <T> T parse(String value, Function<String, T> parser, String description) {
        try {
            return parser.apply(Objects.requireNonNull(value, description + " cannot be null"));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("failed parsing " + description + " '" + value + "': " + Exceptions.toMessageString(e));
        }
    }

    public static String requireLength(String value, String description, int lower, int upper) {
        Validation.requireInRange(value.length(), description, lower, upper);
        return value;
    }

    public static String requireMatch(String value, String description, Pattern pattern) {
        return Validation.require(pattern.matcher(value).matches(), value, description + " must match '" + pattern + "'");
    }

    public static String requireNonBlank(String value, String description) {
        return Validation.require(!value.isBlank(), value, description + " cannot be blank");
    }

    public static <T extends Comparable<? super T>> T requireAtLeast(T value, String description, T lower) {
        return Validation.require(lower.compareTo(value) <= 0, value, description + " must be at least '" + lower + "'");
    }

    public static <T extends Comparable<? super T>> T requireAtMost(T value, String description, T upper) {
        return Validation.require(upper.compareTo(value) >= 0, value, description + " must be at most '" + upper + "'");
    }

    public static <T extends Comparable<? super T>> T requireInRange(T value, String description, T lower, T upper) {
        if (lower.compareTo(upper) > 0) {
            throw new IllegalArgumentException("lower bound cannot be greater than upper bound, but got '" + lower + "' > '" + upper + "'");
        }
        return Validation.require(lower.compareTo(value) <= 0 && upper.compareTo(value) >= 0, value, description + " must be at least '" + lower + "' and at most '" + upper + "'");
    }

    public static <T> T require(boolean condition, T value, String description) {
        if (condition) {
            return value;
        }
        throw new IllegalArgumentException(description + ", but got: '" + value + "'");
    }

    public static void requireNonNulls(Object ... objs) {
        for (int i = 0; i < objs.length; ++i) {
            int effectivelyFinal = i;
            Objects.requireNonNull(objs[i], () -> "Argument at index %d is null".formatted(effectivelyFinal));
        }
    }
}

