/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListenableArrayList<ITEM>
extends ArrayList<ITEM> {
    private List<Runnable> listeners = null;

    public ListenableArrayList() {
    }

    public ListenableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public boolean add(ITEM e) {
        boolean result = super.add(e);
        this.notifyListeners();
        return result;
    }

    @Override
    public void add(int index, ITEM e) {
        super.add(index, e);
        this.notifyListeners();
    }

    @Override
    public boolean addAll(Collection<? extends ITEM> a) {
        boolean result = super.addAll(a);
        this.notifyListeners();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends ITEM> a) {
        boolean result = super.addAll(index, a);
        this.notifyListeners();
        return result;
    }

    @Override
    public ITEM set(int index, ITEM e) {
        ITEM result = super.set(index, e);
        this.notifyListeners();
        return result;
    }

    public List<Runnable> listeners() {
        if (this.listeners == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.listeners);
    }

    public void addListener(Runnable listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Runnable>();
        }
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }
}

