/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.time;

import java.time.Duration;
import java.util.Random;

public class ExponentialBackoff {
    private static final double RANDOMIZATION_FACTOR = 0.5;
    private final Duration initialDelay;
    private final Duration maxDelay;
    private final Random random;

    public ExponentialBackoff(Duration initialDelay, Duration maxDelay) {
        this(initialDelay, maxDelay, new Random());
    }

    ExponentialBackoff(Duration initialDelay, Duration maxDelay, Random random) {
        this.initialDelay = ExponentialBackoff.requireNonNegative(initialDelay);
        this.maxDelay = ExponentialBackoff.requireNonNegative(maxDelay);
        this.random = random;
    }

    public Duration delay(int attempt) {
        if (attempt < 1) {
            throw new IllegalArgumentException("Attempt must be positive");
        }
        double currentDelay = (long)attempt * this.initialDelay.toMillis();
        double delta = 0.5 * currentDelay;
        double lowerDelay = currentDelay - delta;
        double upperDelay = currentDelay + delta;
        long millis = (long)Math.min(lowerDelay + this.random.nextDouble() * (upperDelay - lowerDelay + 1.0), (double)this.maxDelay.toMillis());
        return Duration.ofMillis(millis);
    }

    private static Duration requireNonNegative(Duration d) {
        if (d.isNegative()) {
            throw new IllegalArgumentException("Invalid duration: " + d);
        }
        return d;
    }
}

