/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.util.Locale;
import java.util.OptionalInt;

public final class Text {
    private static final boolean[] allowedAsciiChars;

    private Text() {
    }

    public static boolean isTextCharacter(int codepoint) {
        return codepoint < 128 ? allowedAsciiChars[codepoint] : codepoint < 55296 || Text.isTextCharAboveMinSurrogate(codepoint);
    }

    private static boolean isTextCharAboveMinSurrogate(int codepoint) {
        if (codepoint <= 57343) {
            return false;
        }
        if (codepoint < 64976) {
            return true;
        }
        if (codepoint <= 64991) {
            return false;
        }
        if (codepoint >= 1114110) {
            return false;
        }
        return (codepoint & 0xFFFF) < 65534;
    }

    public static OptionalInt validateTextString(String string) {
        int charCount;
        for (int i = 0; i < string.length(); i += charCount) {
            int codePoint = string.codePointAt(i);
            if (!Text.isTextCharacter(codePoint)) {
                return OptionalInt.of(codePoint);
            }
            charCount = Character.charCount(codePoint);
            if (!Character.isHighSurrogate(string.charAt(i))) continue;
            if (charCount == 1) {
                return OptionalInt.of(string.codePointAt(i));
            }
            if (Character.isLowSurrogate(string.charAt(i + 1))) continue;
            return OptionalInt.of(string.codePointAt(i + 1));
        }
        return OptionalInt.empty();
    }

    public static boolean isValidTextString(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            int codePoint = string.codePointAt(i);
            if (codePoint < 128) {
                if (allowedAsciiChars[codePoint]) continue;
                return false;
            }
            if (codePoint < 55296) continue;
            if (!Text.isTextCharAboveMinSurrogate(codePoint)) {
                return false;
            }
            if (Character.isBmpCodePoint(codePoint)) continue;
            ++i;
        }
        return true;
    }

    public static boolean isDisplayable(int codePoint) {
        switch (Character.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    private static StringBuilder lazy(StringBuilder sb, String s, int i) {
        if (sb == null) {
            sb = new StringBuilder(s.substring(0, i));
        }
        sb.append(' ');
        return sb;
    }

    public static String stripInvalidCharacters(String string) {
        int charCount;
        StringBuilder stripped = null;
        for (int i = 0; i < string.length(); i += charCount) {
            int codePoint = string.codePointAt(i);
            charCount = Character.charCount(codePoint);
            if (!Text.isTextCharacter(codePoint)) {
                stripped = Text.lazy(stripped, string, i);
                continue;
            }
            if (Character.isHighSurrogate(string.charAt(i))) {
                if (charCount == 1) {
                    stripped = Text.lazy(stripped, string, i);
                    continue;
                }
                if (!Character.isLowSurrogate(string.charAt(i + 1))) {
                    stripped = Text.lazy(stripped, string, i);
                    continue;
                }
                if (stripped == null) continue;
                stripped.appendCodePoint(codePoint);
                continue;
            }
            if (stripped == null) continue;
            stripped.appendCodePoint(codePoint);
        }
        return stripped != null ? stripped.toString() : string;
    }

    public static String truncate(String s, int length) {
        if (s.codePointCount(0, s.length()) <= length) {
            return s;
        }
        if (length <= 4) {
            return Text.substringByCodepoints(s, 0, length);
        }
        return Text.substringByCodepoints(s, 0, length - 4) + " ...";
    }

    public static String substringByCodepoints(String s, int fromCP, int toCP) {
        int from;
        int len = s.length();
        if (fromCP >= len || fromCP >= toCP) {
            return "";
        }
        try {
            from = s.offsetByCodePoints(0, fromCP);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
        if (from >= len) {
            return "";
        }
        int lenCP = toCP - fromCP;
        if (from + lenCP >= len) {
            return s.substring(from);
        }
        try {
            int to = s.offsetByCodePoints(from, toCP - fromCP);
            return to >= len ? s.substring(from) : s.substring(from, to);
        }
        catch (IndexOutOfBoundsException e) {
            return s.substring(from);
        }
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    static {
        int i;
        allowedAsciiChars = new boolean[128];
        Text.allowedAsciiChars[0] = false;
        Text.allowedAsciiChars[1] = false;
        Text.allowedAsciiChars[2] = false;
        Text.allowedAsciiChars[3] = false;
        Text.allowedAsciiChars[4] = false;
        Text.allowedAsciiChars[5] = false;
        Text.allowedAsciiChars[6] = false;
        Text.allowedAsciiChars[7] = false;
        Text.allowedAsciiChars[8] = false;
        Text.allowedAsciiChars[9] = true;
        Text.allowedAsciiChars[10] = true;
        Text.allowedAsciiChars[11] = false;
        Text.allowedAsciiChars[12] = false;
        Text.allowedAsciiChars[13] = true;
        for (i = 14; i < 32; ++i) {
            Text.allowedAsciiChars[i] = false;
        }
        for (i = 32; i < 127; ++i) {
            Text.allowedAsciiChars[i] = true;
        }
        Text.allowedAsciiChars[127] = true;
    }
}

