/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.impl.TensorAddressAny;
import java.util.Arrays;

final class TensorAddressAnyN
extends TensorAddressAny {
    private final long[] labels;

    TensorAddressAnyN(long[] labels) {
        if (labels.length < 1) {
            throw new IllegalArgumentException("Need at least 1 label");
        }
        this.labels = labels;
    }

    @Override
    public int size() {
        return this.labels.length;
    }

    @Override
    public long numericLabel(int i) {
        return this.labels[i];
    }

    @Override
    public TensorAddress withLabel(int labelIndex, long label) {
        long[] copy = Arrays.copyOf(this.labels, this.labels.length);
        copy[labelIndex] = label;
        return new TensorAddressAnyN(copy);
    }

    public int hashCode() {
        long hash = Math.abs(this.labels[0]);
        for (int i = 0; i < this.size(); ++i) {
            hash |= Math.abs(this.labels[i]) << 32 - Long.numberOfLeadingZeros(hash);
        }
        return (int)hash;
    }

    public boolean equals(Object o) {
        TensorAddressAnyN any;
        block4: {
            block3: {
                if (!(o instanceof TensorAddressAnyN)) break block3;
                any = (TensorAddressAnyN)o;
                if (this.size() == any.size()) break block4;
            }
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.labels[i] == any.labels[i]) continue;
            return false;
        }
        return true;
    }
}

