/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.impl.TensorAddressAny;

final class TensorAddressAny2
extends TensorAddressAny {
    private final long label0;
    private final long label1;

    TensorAddressAny2(long label0, long label1) {
        this.label0 = label0;
        this.label1 = label1;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public long numericLabel(int i) {
        return switch (i) {
            case 0 -> this.label0;
            case 1 -> this.label1;
            default -> throw new IndexOutOfBoundsException("Index is not in [0,1]: " + i);
        };
    }

    @Override
    public TensorAddress withLabel(int labelIndex, long label) {
        return switch (labelIndex) {
            case 0 -> new TensorAddressAny2(label, this.label1);
            case 1 -> new TensorAddressAny2(this.label0, label);
            default -> throw new IllegalArgumentException("No label " + labelIndex);
        };
    }

    public int hashCode() {
        long hash = Math.abs(this.label0) | Math.abs(this.label1) << 64 - Long.numberOfLeadingZeros(Math.abs(this.label0));
        return (int)hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof TensorAddressAny2)) return false;
        TensorAddressAny2 any = (TensorAddressAny2)o;
        if (this.label0 != any.label0) return false;
        if (this.label1 != any.label1) return false;
        return true;
    }
}

