/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.BufferedOutput;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.ObjectSymbolTraverser;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import com.yahoo.slime.Utf8Codec;

final class BinaryEncoder
implements ArrayTraverser,
ObjectSymbolTraverser {
    private final BufferedOutput out;

    BinaryEncoder() {
        this(new BufferedOutput());
    }

    BinaryEncoder(BufferedOutput output) {
        this.out = output;
    }

    BufferedOutput encode(Slime slime) {
        this.out.reset();
        this.encodeSymbolTable(slime);
        this.encodeValue(slime.get());
        return this.out;
    }

    void encode_cmpr_int(int value) {
        byte next = (byte)(value & 0x7F);
        value >>>= 7;
        while (value != 0) {
            next = (byte)(next | 0xFFFFFF80);
            this.out.put(next);
            next = (byte)(value & 0x7F);
            value >>>= 7;
        }
        this.out.put(next);
    }

    void write_type_and_size(int type, int size) {
        if (size <= 30) {
            this.out.put(BinaryFormat.encode_type_and_meta(type, size + 1));
        } else {
            this.out.put(BinaryFormat.encode_type_and_meta(type, 0));
            this.encode_cmpr_int(size);
        }
    }

    void write_type_and_bytes_le(int type, long bits) {
        int pos = this.out.position();
        byte val = 0;
        this.out.put(val);
        while (bits != 0L) {
            val = (byte)(bits & 0xFFL);
            bits >>>= 8;
            this.out.put(val);
        }
        val = BinaryFormat.encode_type_and_meta(type, this.out.position() - pos - 1);
        this.out.absolutePut(pos, val);
    }

    void write_type_and_bytes_be(int type, long bits) {
        int pos = this.out.position();
        byte val = 0;
        this.out.put(val);
        while (bits != 0L) {
            val = (byte)(bits >> 56);
            bits <<= 8;
            this.out.put(val);
        }
        val = BinaryFormat.encode_type_and_meta(type, this.out.position() - pos - 1);
        this.out.absolutePut(pos, val);
    }

    void encodeNIX() {
        this.out.put(Type.NIX.ID);
    }

    void encodeBOOL(boolean value) {
        this.out.put(BinaryFormat.encode_type_and_meta(Type.BOOL.ID, value ? 1 : 0));
    }

    void encodeLONG(long value) {
        this.write_type_and_bytes_le(Type.LONG.ID, BinaryFormat.encode_zigzag(value));
    }

    void encodeDOUBLE(double value) {
        this.write_type_and_bytes_be(Type.DOUBLE.ID, BinaryFormat.encode_double(value));
    }

    void encodeSTRING(byte[] value) {
        this.write_type_and_size(Type.STRING.ID, value.length);
        this.out.put(value);
    }

    void encodeDATA(byte[] value) {
        this.write_type_and_size(Type.DATA.ID, value.length);
        this.out.put(value);
    }

    void encodeARRAY(Inspector inspector) {
        this.write_type_and_size(Type.ARRAY.ID, inspector.children());
        BinaryEncoder at = this;
        inspector.traverse(at);
    }

    void encodeOBJECT(Inspector inspector) {
        this.write_type_and_size(Type.OBJECT.ID, inspector.children());
        BinaryEncoder ot = this;
        inspector.traverse(ot);
    }

    void encodeValue(Inspector inspector) {
        switch (inspector.type()) {
            case NIX: {
                this.encodeNIX();
                return;
            }
            case BOOL: {
                this.encodeBOOL(inspector.asBool());
                return;
            }
            case LONG: {
                this.encodeLONG(inspector.asLong());
                return;
            }
            case DOUBLE: {
                this.encodeDOUBLE(inspector.asDouble());
                return;
            }
            case STRING: {
                this.encodeSTRING(inspector.asUtf8());
                return;
            }
            case DATA: {
                this.encodeDATA(inspector.asData());
                return;
            }
            case ARRAY: {
                this.encodeARRAY(inspector);
                return;
            }
            case OBJECT: {
                this.encodeOBJECT(inspector);
                return;
            }
        }
        assert (false) : "Should not be reached";
    }

    void encodeSymbolTable(Slime slime) {
        int numSymbols = slime.symbols();
        this.encode_cmpr_int(numSymbols);
        for (int i = 0; i < numSymbols; ++i) {
            String name = slime.inspect(i);
            byte[] bytes = Utf8Codec.encode(name);
            this.encode_cmpr_int(bytes.length);
            this.out.put(bytes);
        }
    }

    @Override
    public void entry(int idx, Inspector inspector) {
        this.encodeValue(inspector);
    }

    @Override
    public void field(int symbol, Inspector inspector) {
        this.encode_cmpr_int(symbol);
        this.encodeValue(inspector);
    }
}

