/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.protect;

import com.yahoo.yolean.Exceptions;

public class ErrorMessage {
    protected int code;
    protected String message;
    protected String detailedMessage = null;
    protected Throwable cause = null;

    public ErrorMessage() {
    }

    public ErrorMessage(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public ErrorMessage(int code, String message, String detailedMessage) {
        this(code, message);
        this.detailedMessage = detailedMessage;
    }

    public ErrorMessage(int code, String message, String detailedMessage, Throwable cause) {
        this(code, message, detailedMessage);
        this.cause = cause;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int hashCode() {
        return this.code * 7 + this.message.hashCode() + (this.detailedMessage == null ? 0 : 17 * this.detailedMessage.hashCode());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)o;
        if (this.code != other.code) {
            return false;
        }
        if (!this.message.equals(other.message)) {
            return false;
        }
        if (this.detailedMessage == null) {
            return other.detailedMessage == null;
        }
        if (other.detailedMessage == null) {
            return false;
        }
        return this.detailedMessage.equals(other.detailedMessage);
    }

    public String toString() {
        Object details = "";
        if (this.detailedMessage != null) {
            details = this.detailedMessage;
        }
        if (this.cause != null) {
            if (((String)details).length() > 0) {
                details = (String)details + ": ";
            }
            details = (String)details + Exceptions.toMessageString(this.cause);
        }
        if (((String)details).length() > 0) {
            details = " (" + (String)details + ")";
        }
        return "error : " + this.message + (String)details;
    }
}

