/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;

public class LazyInputStream
extends InputStream {
    private Supplier<InputStream> source;
    private InputStream delegate;

    public LazyInputStream(Supplier<InputStream> source) {
        this.source = source;
    }

    private InputStream in() {
        if (this.delegate == null) {
            this.delegate = this.source.get();
            this.source = null;
        }
        return this.delegate;
    }

    @Override
    public int read() throws IOException {
        return this.in().read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in().available();
    }

    @Override
    public void close() throws IOException {
        this.in().close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in().mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in().reset();
    }

    @Override
    public boolean markSupported() {
        return this.in().markSupported();
    }
}

