/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.access.simple;

import com.yahoo.data.access.ArrayTraverser;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.ObjectTraverser;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.JsonRender;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Value
implements Inspector {
    private static final Value empty = new EmptyValue();
    private static final Value invalid = new Value();
    private static final byte[] empty_array = new byte[0];

    public static Inspector empty() {
        return empty;
    }

    public static Inspector invalid() {
        return invalid;
    }

    @Override
    public Inspector inspect() {
        return this;
    }

    @Override
    public boolean valid() {
        return false;
    }

    @Override
    public Type type() {
        return Type.EMPTY;
    }

    @Override
    public int entryCount() {
        return 0;
    }

    @Override
    public int fieldCount() {
        return 0;
    }

    @Override
    public boolean asBool() {
        throw new IllegalStateException("invalid data access!");
    }

    @Override
    public long asLong() {
        throw new IllegalStateException("invalid data access!");
    }

    @Override
    public double asDouble() {
        throw new IllegalStateException("invalid data access!");
    }

    @Override
    public String asString() {
        throw new IllegalStateException("invalid data access!");
    }

    @Override
    public byte[] asUtf8() {
        throw new IllegalStateException("invalid data access!");
    }

    @Override
    public byte[] asData() {
        throw new IllegalStateException("invalid data access!");
    }

    @Override
    public boolean asBool(boolean defaultValue) {
        return defaultValue;
    }

    @Override
    public long asLong(long defaultValue) {
        return defaultValue;
    }

    @Override
    public double asDouble(double defaultValue) {
        return defaultValue;
    }

    @Override
    public String asString(String defaultValue) {
        return defaultValue;
    }

    @Override
    public byte[] asUtf8(byte[] defaultValue) {
        return defaultValue;
    }

    @Override
    public byte[] asData(byte[] defaultValue) {
        return defaultValue;
    }

    @Override
    public void traverse(ArrayTraverser at) {
    }

    @Override
    public void traverse(ObjectTraverser ot) {
    }

    @Override
    public Inspector entry(int idx) {
        return invalid;
    }

    @Override
    public Inspector field(String name) {
        return invalid;
    }

    @Override
    public Iterable<Inspector> entries() {
        return List.of();
    }

    @Override
    public Iterable<Map.Entry<String, Inspector>> fields() {
        return List.of();
    }

    public StringBuilder writeJson(StringBuilder target) {
        return JsonRender.render(this, target, true);
    }

    public String toJson() {
        return this.writeJson(new StringBuilder()).toString();
    }

    public String toString() {
        return this.toJson();
    }

    public static class EmptyValue
    extends Value {
        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public boolean asBool() {
            return false;
        }

        @Override
        public long asLong() {
            return 0L;
        }

        @Override
        public double asDouble() {
            return 0.0;
        }

        @Override
        public String asString() {
            return "";
        }

        @Override
        public byte[] asUtf8() {
            return empty_array;
        }

        @Override
        public byte[] asData() {
            return empty_array;
        }
    }

    public static class ObjectValue
    extends Value {
        private final Map<String, Inspector> values = new LinkedHashMap<String, Inspector>();

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Type type() {
            return Type.OBJECT;
        }

        @Override
        public int fieldCount() {
            return this.values.size();
        }

        @Override
        public Inspector field(String name) {
            Inspector v = this.values.get(name);
            if (v == null) {
                return invalid;
            }
            return v;
        }

        @Override
        public void traverse(ObjectTraverser ot) {
            for (Map.Entry<String, Inspector> i : this.values.entrySet()) {
                ot.field(i.getKey(), i.getValue());
            }
        }

        @Override
        public Iterable<Map.Entry<String, Inspector>> fields() {
            return Collections.unmodifiableMap(this.values).entrySet();
        }

        public ObjectValue put(String name, Inspector v) {
            if (name == null) {
                throw new IllegalArgumentException("field name was <null>");
            }
            if (v == null || !v.valid()) {
                throw new IllegalArgumentException("tried to put an invalid value into an object");
            }
            this.values.put(name, v);
            return this;
        }

        public ObjectValue put(String name, String value) {
            return this.put(name, new StringValue(value));
        }

        public ObjectValue put(String name, long value) {
            return this.put(name, new LongValue(value));
        }

        public ObjectValue put(String name, int value) {
            return this.put(name, new LongValue(value));
        }

        public ObjectValue put(String name, double value) {
            return this.put(name, new DoubleValue(value));
        }
    }

    public static class ArrayValue
    extends Value {
        private final List<Inspector> values;

        public ArrayValue() {
            this.values = new ArrayList<Inspector>();
        }

        public ArrayValue(int capacity) {
            this.values = new ArrayList<Inspector>(capacity);
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Type type() {
            return Type.ARRAY;
        }

        @Override
        public int entryCount() {
            return this.values.size();
        }

        @Override
        public Inspector entry(int idx) {
            if (idx < 0 || idx >= this.values.size()) {
                return invalid;
            }
            return this.values.get(idx);
        }

        @Override
        public void traverse(ArrayTraverser at) {
            int idx = 0;
            for (Inspector i : this.values) {
                at.entry(idx++, i);
            }
        }

        @Override
        public Iterable<Inspector> entries() {
            return Collections.unmodifiableList(this.values);
        }

        public ArrayValue add(Inspector v) {
            if (v == null || !v.valid()) {
                throw new IllegalArgumentException("tried to add an invalid value to an array");
            }
            this.values.add(v);
            return this;
        }

        public ArrayValue add(String value) {
            return this.add(new StringValue(value));
        }

        public ArrayValue add(long value) {
            return this.add(new LongValue(value));
        }

        public ArrayValue add(int value) {
            return this.add(new LongValue(value));
        }

        public ArrayValue add(double value) {
            return this.add(new DoubleValue(value));
        }
    }

    public static class DataValue
    extends Value {
        private byte[] value;

        public DataValue(byte[] v) {
            this.value = v;
            if (v == null) {
                this.value = empty_array;
            }
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Type type() {
            return Type.DATA;
        }

        @Override
        public byte[] asData() {
            return this.value;
        }

        @Override
        public byte[] asData(byte[] x) {
            return this.value;
        }
    }

    public static class StringValue
    extends Value {
        private String string_value = null;
        private byte[] utf8_value = null;

        private void handle_null() {
            if (this.string_value == null && this.utf8_value == null) {
                this.string_value = "";
                this.utf8_value = empty_array;
            }
        }

        public StringValue(String v) {
            this.string_value = v;
            this.handle_null();
        }

        public StringValue(byte[] v) {
            this.utf8_value = v;
            this.handle_null();
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Type type() {
            return Type.STRING;
        }

        @Override
        public String asString() {
            if (this.string_value == null) {
                this.string_value = new String(this.utf8_value, StandardCharsets.UTF_8);
            }
            return this.string_value;
        }

        @Override
        public String asString(String x) {
            return this.asString();
        }

        @Override
        public byte[] asUtf8() {
            if (this.utf8_value == null) {
                this.utf8_value = this.string_value.getBytes(StandardCharsets.UTF_8);
            }
            return this.utf8_value;
        }

        @Override
        public byte[] asUtf8(byte[] x) {
            return this.asUtf8();
        }
    }

    public static class DoubleValue
    extends Value {
        private final double value;

        public DoubleValue(double v) {
            this.value = v;
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Type type() {
            return Type.DOUBLE;
        }

        @Override
        public double asDouble() {
            return this.value;
        }

        @Override
        public long asLong() {
            return (long)this.value;
        }

        @Override
        public double asDouble(double x) {
            return this.value;
        }

        @Override
        public long asLong(long x) {
            return (long)this.value;
        }
    }

    public static class LongValue
    extends Value {
        private final long value;

        public LongValue(long v) {
            this.value = v;
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Type type() {
            return Type.LONG;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }

        @Override
        public long asLong(long x) {
            return this.value;
        }

        @Override
        public double asDouble(double x) {
            return this.value;
        }
    }

    public static class BoolValue
    extends Value {
        private final boolean value;

        public BoolValue(boolean v) {
            this.value = v;
        }

        @Override
        public boolean valid() {
            return true;
        }

        @Override
        public Type type() {
            return Type.BOOL;
        }

        @Override
        public boolean asBool() {
            return this.value;
        }

        @Override
        public boolean asBool(boolean x) {
            return this.value;
        }
    }
}

