/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.data.access.helpers;

import com.yahoo.collections.Hashlet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.Function;

public class MatchFeatureFilter
implements Function<Hashlet<String, Integer>, Hashlet<String, Integer>> {
    private final IdentityHashMap<Hashlet<String, Integer>, Hashlet<String, Integer>> mappings = new IdentityHashMap();
    private final Collection<String> removeList;

    public MatchFeatureFilter(Collection<String> removeList) {
        this.removeList = removeList;
    }

    Hashlet<String, Integer> filter(Hashlet<String, Integer> input) {
        Hashlet<String, Integer> result = new Hashlet<String, Integer>();
        result.reserve(input.size());
        for (int i = 0; i < input.size(); ++i) {
            String k = input.key(i);
            if (this.removeList.contains(k)) continue;
            Integer v = input.value(i);
            result.put(k, v);
        }
        return result;
    }

    @Override
    public Hashlet<String, Integer> apply(Hashlet<String, Integer> input) {
        return this.mappings.computeIfAbsent(input, k -> this.filter((Hashlet<String, Integer>)k));
    }
}

