/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent.maintenance;

import com.yahoo.concurrent.maintenance.JobControlState;
import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.transaction.Mutex;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;

public class JobControl {
    private final Map<String, Maintainer> startedJobs = new ConcurrentSkipListMap<String, Maintainer>();
    private final JobControlState state;

    public JobControl(JobControlState state) {
        this.state = Objects.requireNonNull(state);
    }

    public void started(String jobSimpleClassName, Maintainer maintainer) {
        this.startedJobs.put(jobSimpleClassName, maintainer);
    }

    public Set<String> jobs() {
        return Collections.unmodifiableSet(this.startedJobs.keySet());
    }

    public Set<String> inactiveJobs() {
        return this.state.readInactiveJobs();
    }

    public boolean isActive(String jobSimpleClassName) {
        return !this.inactiveJobs().contains(jobSimpleClassName);
    }

    public void run(String jobSimpleClassName) {
        Maintainer job = this.startedJobs.get(jobSimpleClassName);
        if (job == null) {
            throw new IllegalArgumentException("No such job '" + jobSimpleClassName + "'");
        }
        job.lockAndMaintain(true);
    }

    public Mutex lockJob(String jobSimpleClassName) {
        return this.state.lockMaintenanceJob(jobSimpleClassName);
    }
}

