/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class TinyIdentitySet<E>
implements Set<E> {
    private Object[] entries;
    private int size = 0;

    public TinyIdentitySet(int initSize) {
        this.entries = new Object[initSize];
    }

    public TinyIdentitySet() {
        this(4);
    }

    public int indexOf(Object e) {
        for (int i = 0; i < this.size; ++i) {
            if (e != this.entries[i]) continue;
            return i;
        }
        return -1;
    }

    private void clean() {
        int offset = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.entries[i] == null) {
                ++offset;
                continue;
            }
            this.entries[i - offset] = this.entries[i];
        }
        this.size -= offset;
    }

    private void grow() {
        this.entries = Arrays.copyOf(this.entries, this.entries.length + 10);
    }

    private void append(Object arg) {
        if (this.size == this.entries.length) {
            this.grow();
        }
        this.entries[this.size++] = arg;
    }

    @Override
    public boolean add(E arg) {
        int i = this.indexOf(arg);
        if (i >= 0) {
            return false;
        }
        this.append(arg);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> arg) {
        boolean changed = false;
        for (E entry : arg) {
            changed |= this.add(entry);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(Object arg) {
        return this.indexOf(arg) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> arg) {
        for (Object entry : arg) {
            if (this.indexOf(entry) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator();
    }

    private void delete(int i) {
        if (i < 0 || i >= this.size) {
            return;
        }
        --this.size;
        while (i < this.size) {
            this.entries[i] = this.entries[i + 1];
            ++i;
        }
        this.entries[i] = null;
    }

    @Override
    public boolean remove(Object arg) {
        int i = this.indexOf(arg);
        if (i < 0) {
            return false;
        }
        this.delete(i);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> arg) {
        boolean changed = false;
        for (Object entry : arg) {
            int i = this.indexOf(entry);
            if (i < 0) continue;
            this.entries[i] = null;
            changed = true;
        }
        if (changed) {
            this.clean();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> arg) {
        boolean changed = false;
        for (int i = 0; i < this.size; ++i) {
            Object entry = this.entries[i];
            boolean exists = false;
            for (Object v : arg) {
                if (v != entry) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.entries[i] = null;
            changed = true;
        }
        if (changed) {
            this.clean();
        }
        return changed;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.entries, this.size);
    }

    @Override
    public <T> T[] toArray(T[] arg) {
        return Arrays.copyOf(this.entries, this.size, arg.getClass());
    }

    private class ArrayIterator<T>
    implements Iterator<E> {
        private int i = -1;
        private boolean removed = false;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i + 1 < TinyIdentitySet.this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.removed = false;
            return TinyIdentitySet.this.entries[++this.i];
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException("Trying to remove same element twice.");
            }
            if (this.i == -1) {
                throw new IllegalStateException("Trying to remove before entering iterator.");
            }
            TinyIdentitySet.this.delete(this.i--);
            this.removed = true;
        }
    }
}

