/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import com.yahoo.collections.ListenableArrayList;
import java.util.Collection;

public class FreezableArrayList<ITEM>
extends ListenableArrayList<ITEM> {
    private static final long serialVersionUID = 5900452593651895638L;
    private final boolean permitAddAfterFreeze;
    private boolean frozen = false;

    public FreezableArrayList() {
        this(false);
    }

    public FreezableArrayList(int initialCapacity) {
        this(false, initialCapacity);
    }

    public FreezableArrayList(boolean permitAddAfterFreeze) {
        this.permitAddAfterFreeze = permitAddAfterFreeze;
    }

    public FreezableArrayList(boolean permitAddAfterFreeze, int initialCapacity) {
        super(initialCapacity);
        this.permitAddAfterFreeze = permitAddAfterFreeze;
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean add(ITEM e) {
        if (!this.permitAddAfterFreeze) {
            this.throwIfFrozen();
        }
        return super.add(e);
    }

    @Override
    public void add(int index, ITEM e) {
        this.throwIfFrozen();
        super.add(index, e);
    }

    @Override
    public boolean addAll(Collection<? extends ITEM> a) {
        if (!this.permitAddAfterFreeze) {
            this.throwIfFrozen();
        }
        return super.addAll(a);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ITEM> a) {
        this.throwIfFrozen();
        return super.addAll(index, a);
    }

    @Override
    public ITEM set(int index, ITEM e) {
        this.throwIfFrozen();
        return super.set(index, e);
    }

    @Override
    public ITEM remove(int index) {
        this.throwIfFrozen();
        return (ITEM)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.throwIfFrozen();
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.throwIfFrozen();
        super.clear();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.throwIfFrozen();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.throwIfFrozen();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.throwIfFrozen();
        return super.retainAll(c);
    }

    private void throwIfFrozen() {
        if (this.frozen) {
            throw new UnsupportedOperationException(this + " is frozen");
        }
    }
}

