/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.json;

import ai.vespa.json.InvalidJsonException;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.slime.Type;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Json
implements Iterable<Json> {
    private final Inspector inspector;
    private final String path;

    public static Json of(Slime slime) {
        return Json.of(slime.get());
    }

    public static Json of(Inspector inspector) {
        return new Json(inspector, "");
    }

    public static Json of(String json) {
        return Json.of(SlimeUtils.jsonToSlime(json));
    }

    private Json(Inspector inspector, String path) {
        this.inspector = Objects.requireNonNull(inspector);
        this.path = Objects.requireNonNull(path);
    }

    public Json f(String field) {
        return this.field(field);
    }

    public Json field(String field) {
        this.requireType(Type.OBJECT);
        return new Json(this.inspector.field(field), this.path.isEmpty() ? field : "%s.%s".formatted(this.path, field));
    }

    public Json a(int index) {
        return this.entry(index);
    }

    public Json entry(int index) {
        this.requireType(Type.ARRAY);
        return new Json(this.inspector.entry(index), "%s[%d]".formatted(this.path, index));
    }

    public int length() {
        return this.inspector.children();
    }

    public boolean has(String field) {
        return this.inspector.field(field).valid();
    }

    public boolean isPresent() {
        return this.inspector.valid();
    }

    public boolean isMissing() {
        return !this.isPresent();
    }

    public Optional<String> asOptionalString() {
        return Optional.ofNullable(this.asString(null));
    }

    public String asString() {
        this.requireType(Type.STRING);
        return this.inspector.asString();
    }

    public String asString(String defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asString();
    }

    public Optional<Long> asOptionalLong() {
        return this.isMissing() ? Optional.empty() : Optional.of(this.asLong());
    }

    public long asLong() {
        this.requireType(Type.LONG, Type.DOUBLE);
        return this.inspector.asLong();
    }

    public long asLong(long defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asLong();
    }

    public Optional<Double> asOptionalDouble() {
        return this.isMissing() ? Optional.empty() : Optional.of(this.asDouble());
    }

    public double asDouble() {
        this.requireType(Type.LONG, Type.DOUBLE);
        return this.inspector.asDouble();
    }

    public double asDouble(double defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asDouble();
    }

    public Optional<Boolean> asOptionalBool() {
        return this.isMissing() ? Optional.empty() : Optional.of(this.asBool());
    }

    public boolean asBool() {
        this.requireType(Type.BOOL);
        return this.inspector.asBool();
    }

    public boolean asBool(boolean defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asBool();
    }

    public Optional<Instant> asOptionalInstant() {
        return this.isMissing() ? Optional.empty() : Optional.of(this.asInstant());
    }

    public Instant asInstant() {
        this.requireType(Type.STRING);
        try {
            return Instant.parse(this.asString());
        }
        catch (DateTimeParseException e) {
            throw new InvalidJsonException("Expected JSON member '%s' to be a valid timestamp: %s".formatted(this.path, e.getMessage()));
        }
    }

    public Instant asInstant(Instant defaultValue) {
        if (this.isMissing()) {
            return defaultValue;
        }
        return this.asInstant();
    }

    public List<Json> toList() {
        ArrayList list = new ArrayList(this.length());
        this.forEachEntry((Json json) -> list.add(json));
        return List.copyOf(list);
    }

    public Stream<Json> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public String toJson(boolean pretty) {
        return SlimeUtils.toJson(this.inspector, !pretty);
    }

    public boolean isString() {
        return this.inspector.type() == Type.STRING;
    }

    public boolean isArray() {
        return this.inspector.type() == Type.ARRAY;
    }

    public boolean isLong() {
        return this.inspector.type() == Type.LONG;
    }

    public boolean isDouble() {
        return this.inspector.type() == Type.DOUBLE;
    }

    public boolean isBool() {
        return this.inspector.type() == Type.BOOL;
    }

    public boolean isNumber() {
        return this.isLong() || this.isDouble();
    }

    public boolean isObject() {
        return this.inspector.type() == Type.OBJECT;
    }

    @Override
    public Iterator<Json> iterator() {
        this.requireType(Type.ARRAY);
        return new Iterator<Json>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < Json.this.length();
            }

            @Override
            public Json next() {
                return Json.this.entry(this.current++);
            }
        };
    }

    public void forEachField(BiConsumer<String, Json> consumer) {
        this.requireType(Type.OBJECT);
        this.inspector.traverse((name, inspector) -> consumer.accept(name, this.field(name)));
    }

    public void forEachEntry(BiConsumer<Integer, Json> consumer) {
        this.requireType(Type.ARRAY);
        for (int i = 0; i < this.length(); ++i) {
            consumer.accept(i, this.entry(i));
        }
    }

    public void forEachEntry(Consumer<Json> consumer) {
        this.requireType(Type.ARRAY);
        for (int i = 0; i < this.length(); ++i) {
            consumer.accept(this.entry(i));
        }
    }

    private void requireType(Type ... types) {
        this.requirePresent();
        if (!List.of(types).contains((Object)this.inspector.type())) {
            throw this.createInvalidTypeException(types);
        }
    }

    private void requirePresent() {
        if (this.isMissing()) {
            throw this.createMissingMemberException();
        }
    }

    private InvalidJsonException createInvalidTypeException(Type ... expected) {
        String expectedTypesString = Arrays.stream(expected).map(this::toString).collect(Collectors.joining("' or '", "'", "'"));
        String pathString = this.path.isEmpty() ? "JSON" : "JSON member '%s'".formatted(this.path);
        return new InvalidJsonException("Expected %s to be a %s but got '%s'".formatted(pathString, expectedTypesString, this.toString(this.inspector.type())));
    }

    private InvalidJsonException createMissingMemberException() {
        return new InvalidJsonException(this.path.isEmpty() ? "Missing JSON" : "Missing JSON member '%s'".formatted(this.path));
    }

    private String toString(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.NIX -> "null";
            case Type.BOOL -> "boolean";
            case Type.LONG -> "integer";
            case Type.DOUBLE -> "float";
            case Type.STRING, Type.DATA -> "string";
            case Type.ARRAY -> "array";
            case Type.OBJECT -> "object";
        };
    }

    public String toString() {
        return "Json{inspector=" + this.inspector + ", path='" + this.path + "'}";
    }

    public static class Builder {
        protected final Cursor cursor;

        public static Array newArray() {
            return new Array(new Slime().setArray());
        }

        public static Object newObject() {
            return new Object(new Slime().setObject());
        }

        public static Object existingSlimeObjectCursor(Cursor cursor) {
            if (cursor.type() != Type.OBJECT) {
                throw new InvalidJsonException("Input is not an object");
            }
            return new Object(cursor);
        }

        public static Array existingSlimeArrayCursor(Cursor cursor) {
            if (cursor.type() != Type.ARRAY) {
                throw new InvalidJsonException("Input is not an array");
            }
            return new Array(cursor);
        }

        private Builder(Cursor cursor) {
            this.cursor = cursor;
        }

        public Cursor slimeCursor() {
            return this.cursor;
        }

        public Json build() {
            return Json.of(this.cursor);
        }

        public static class Array
        extends Builder {
            private Array(Cursor cursor) {
                super(cursor);
            }

            public Array add(Array array) {
                SlimeUtils.copyArray(array.cursor, this.cursor.addArray());
                return this;
            }

            public Array add(Object object) {
                SlimeUtils.copyObject(object.cursor, this.cursor.addObject());
                return this;
            }

            public Array add(Json json) {
                SlimeUtils.addValue(json.inspector, this.cursor);
                return this;
            }

            public Array add(Builder builder) {
                return this.add(builder.build());
            }

            public Array addArray() {
                return new Array(this.cursor.addArray());
            }

            public Object addObject() {
                return new Object(this.cursor.addObject());
            }

            public Array add(String value) {
                this.cursor.addString(value);
                return this;
            }

            public Array add(long value) {
                this.cursor.addLong(value);
                return this;
            }

            public Array add(double value) {
                this.cursor.addDouble(value);
                return this;
            }

            public Array add(boolean value) {
                this.cursor.addBool(value);
                return this;
            }
        }

        public static class Object
        extends Builder {
            private Object(Cursor cursor) {
                super(cursor);
            }

            public Object set(String field, Array array) {
                SlimeUtils.copyArray(array.cursor, this.cursor.setArray(field));
                return this;
            }

            public Object set(String field, Object object) {
                SlimeUtils.copyObject(object.cursor, this.cursor.setObject(field));
                return this;
            }

            public Object set(String field, Json json) {
                SlimeUtils.setObjectEntry(json.inspector, field, this.cursor);
                return this;
            }

            public Object set(String field, Builder json) {
                SlimeUtils.setObjectEntry(json.build().inspector, field, this.cursor);
                return this;
            }

            public Array setArray(String field) {
                return new Array(this.cursor.setArray(field));
            }

            public Object setObject(String field) {
                return new Object(this.cursor.setObject(field));
            }

            public Object set(String field, String value) {
                this.cursor.setString(field, value);
                return this;
            }

            public Object set(String field, long value) {
                this.cursor.setLong(field, value);
                return this;
            }

            public Object set(String field, double value) {
                this.cursor.setDouble(field, value);
                return this;
            }

            public Object set(String field, boolean value) {
                this.cursor.setBool(field, value);
                return this;
            }

            public Object set(String field, BigDecimal value) {
                this.cursor.setString(field, value.stripTrailingZeros().toPlainString());
                return this;
            }

            public Object set(String field, Instant timestamp) {
                this.cursor.setString(field, timestamp.toString());
                return this;
            }
        }
    }
}

