/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text.internal;

public class SnippetGenerator {
    private static final String OMIT_PREFIX = "[...";
    private static final String OMIT_SUFFIX = " chars omitted]";
    private static final int ASSUMED_OMIT_TEXT_LENGTH = "[...".length() + 4 + " chars omitted]".length();

    public String makeSnippet(String text, int sizeHint) {
        if (text.length() <= Math.max(sizeHint, ASSUMED_OMIT_TEXT_LENGTH)) {
            return text;
        }
        int maxSuffixLength = Math.max(0, (sizeHint - ASSUMED_OMIT_TEXT_LENGTH) / 2);
        int maxPrefixLength = Math.max(0, sizeHint - ASSUMED_OMIT_TEXT_LENGTH - maxSuffixLength);
        String sizeString = Integer.toString(text.length() - maxPrefixLength - maxSuffixLength);
        int snippetLength = maxPrefixLength + OMIT_PREFIX.length() + sizeString.length() + OMIT_SUFFIX.length() + maxSuffixLength;
        if ((double)text.length() <= 1.05 * (double)snippetLength + 5.0) {
            return text;
        }
        return text.substring(0, maxPrefixLength) + OMIT_PREFIX + sizeString + OMIT_SUFFIX + text.substring(text.length() - maxSuffixLength);
    }
}

