/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.List;
import java.util.Objects;

public class ConstantTensor<NAMETYPE extends Name>
extends PrimitiveTensorFunction<NAMETYPE> {
    private final Tensor constant;

    public ConstantTensor(String tensorString) {
        this.constant = Tensor.from(tensorString);
    }

    public ConstantTensor(Tensor tensor) {
        this.constant = tensor;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return List.of();
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("ConstantTensor must have 0 arguments, got " + arguments.size());
        }
        return this;
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return this;
    }

    @Override
    public TensorType type(TypeContext<NAMETYPE> context) {
        return this.constant.type();
    }

    @Override
    public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        return this.constant;
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return this.constant.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash("constant", this.constant.hashCode());
    }
}

