/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.impl.Label;
import com.yahoo.tensor.impl.TensorAddressAny;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class TensorAddress
implements Comparable<TensorAddress> {
    public static TensorAddress of(String[] labels) {
        return TensorAddressAny.of(labels);
    }

    public static TensorAddress ofLabels(String ... labels) {
        return TensorAddressAny.of(labels);
    }

    public static TensorAddress of(long ... labels) {
        return TensorAddressAny.of(labels);
    }

    public static TensorAddress of(int ... labels) {
        return TensorAddressAny.of(labels);
    }

    public abstract int size();

    public abstract String label(int var1);

    public abstract long numericLabel(int var1);

    public abstract TensorAddress withLabel(int var1, long var2);

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int compareTo(TensorAddress other) {
        for (int i = 0; i < this.size(); ++i) {
            int elementComparison = this.label(i).compareTo(other.label(i));
            if (elementComparison == 0) continue;
            return elementComparison;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("cell address (");
        int size = this.size();
        if (size > 0) {
            sb.append(this.label(0));
            for (int i = 1; i < size; ++i) {
                sb.append(',').append(this.label(i));
            }
        }
        return sb.append(')').toString();
    }

    public final String toString(TensorType type) {
        StringBuilder b = new StringBuilder("{");
        for (int i = 0; i < this.size(); ++i) {
            b.append(type.dimensions().get(i).name()).append(":").append(TensorAddress.labelToString(this.label(i)));
            b.append(",");
        }
        if (b.length() > 1) {
            b.setLength(b.length() - 1);
        }
        b.append("}");
        return b.toString();
    }

    public static String labelToString(String label) {
        if (TensorType.labelMatcher.matches(label)) {
            return label;
        }
        if (label.contains("'")) {
            return "\"" + label + "\"";
        }
        return "'" + label + "'";
    }

    public TensorAddress partialCopy(int[] indexMap) {
        long[] labels = new long[indexMap.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.numericLabel(indexMap[i]);
        }
        return TensorAddressAny.ofUnsafe(labels);
    }

    public TensorAddress fullAddressOf(List<TensorType.Dimension> dimensions, int[] densePart) {
        long[] labels = new long[dimensions.size()];
        int mappedIndex = 0;
        int indexedIndex = 0;
        for (int i = 0; i < labels.length; ++i) {
            TensorType.Dimension d = dimensions.get(i);
            if (d.isIndexed()) {
                labels[i] = densePart[indexedIndex];
                ++indexedIndex;
                continue;
            }
            labels[i] = this.numericLabel(mappedIndex);
            ++mappedIndex;
        }
        return TensorAddressAny.ofUnsafe(labels);
    }

    public TensorAddress mappedPartialAddress(TensorType mappedType, List<TensorType.Dimension> dimensions) {
        if (dimensions.size() != this.size()) {
            throw new IllegalArgumentException("Tensor type of " + this + " is not the same size as " + this);
        }
        Builder builder = new Builder(mappedType);
        for (int i = 0; i < dimensions.size(); ++i) {
            TensorType.Dimension dimension = dimensions.get(i);
            if (dimension.isIndexed()) continue;
            builder.add(dimension.name(), this.numericLabel(i));
        }
        return builder.build();
    }

    public static class Builder {
        final TensorType type;
        final long[] labels;

        private static long[] createEmptyLabels(int size) {
            long[] labels = new long[size];
            Arrays.fill(labels, -1L);
            return labels;
        }

        public Builder(TensorType type) {
            this(type, Builder.createEmptyLabels(type.dimensions().size()));
        }

        private Builder(TensorType type, long[] labels) {
            this.type = type;
            this.labels = labels;
        }

        public Builder add(String label) {
            TensorType mappedSubtype = this.type.mappedSubtype();
            if (mappedSubtype.rank() != 1) {
                throw new IllegalArgumentException("Cannot add a label without explicit dimension to a tensor of type " + this.type + ": Must have exactly one mapped dimension");
            }
            this.add(mappedSubtype.dimensions().get(0).name(), label);
            return this;
        }

        public Builder add(String dimension, String label) {
            Objects.requireNonNull(dimension, "dimension cannot be null");
            Objects.requireNonNull(label, "label cannot be null");
            int labelIndex = this.type.indexOfDimensionAsInt(dimension);
            if (labelIndex < 0) {
                throw new IllegalArgumentException(this.type + " does not contain dimension '" + dimension + "'");
            }
            this.labels[labelIndex] = Label.toNumber(label);
            return this;
        }

        @Deprecated
        public Builder add(String dimension, int label) {
            return this.add(dimension, (long)label);
        }

        public Builder add(String dimension, long label) {
            Objects.requireNonNull(dimension, "dimension cannot be null");
            int labelIndex = this.type.indexOfDimensionAsInt(dimension);
            if (labelIndex < 0) {
                throw new IllegalArgumentException(this.type + " does not contain dimension '" + dimension + "'");
            }
            this.labels[labelIndex] = label;
            return this;
        }

        public Builder copy() {
            return new Builder(this.type, Arrays.copyOf(this.labels, this.labels.length));
        }

        public TensorType type() {
            return this.type;
        }

        void validate() {
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] != -1L) continue;
                throw new IllegalArgumentException("Missing a label for dimension '" + this.type.dimensions().get(i).name() + "' for " + this.type);
            }
        }

        public TensorAddress build() {
            this.validate();
            return TensorAddressAny.ofUnsafe(this.labels);
        }
    }

    public static class PartialBuilder
    extends Builder {
        public PartialBuilder(TensorType type) {
            super(type);
        }

        private PartialBuilder(TensorType type, long[] labels) {
            super(type, labels);
        }

        @Override
        public Builder copy() {
            return new PartialBuilder(this.type, Arrays.copyOf(this.labels, this.labels.length));
        }

        @Override
        void validate() {
        }
    }
}

