/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.compress.Compressor;
import java.nio.charset.Charset;

final class BufferedOutput {
    private byte[] buf;
    private int capacity;
    private int pos;

    BufferedOutput(int cap) {
        this.capacity = Math.max(cap, 64);
        this.buf = new byte[this.capacity];
    }

    BufferedOutput() {
        this(4096);
    }

    void reset() {
        this.pos = 0;
    }

    private void reserve(int bytes) {
        if (this.pos + bytes > this.capacity) {
            while (this.pos + bytes > this.capacity) {
                this.capacity *= 2;
            }
            byte[] tmp = new byte[this.capacity];
            System.arraycopy(this.buf, 0, tmp, 0, this.pos);
            this.buf = tmp;
        }
    }

    int position() {
        return this.pos;
    }

    void put(byte b) {
        this.reserve(1);
        this.buf[this.pos++] = b;
    }

    void absolutePut(int position, byte b) {
        this.buf[position] = b;
    }

    void put(byte[] bytes) {
        this.reserve(bytes.length);
        for (byte b : bytes) {
            this.buf[this.pos++] = b;
        }
    }

    byte[] toArray() {
        byte[] ret = new byte[this.pos];
        System.arraycopy(this.buf, 0, ret, 0, this.pos);
        return ret;
    }

    public String toString(Charset charset) {
        return new String(this.buf, 0, this.pos, charset);
    }

    Compressor.Compression compress(Compressor compressor) {
        return compressor.compress(this.buf, this.pos);
    }
}

