/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> reversed(final List<T> elements) {
        return () -> new Iterator<T>(){
            final ListIterator<T> wrapped;
            {
                this.wrapped = elements.listIterator(elements.size());
            }

            @Override
            public boolean hasNext() {
                return this.wrapped.hasPrevious();
            }

            @Override
            public T next() {
                return this.wrapped.previous();
            }

            @Override
            public void remove() {
                this.wrapped.remove();
            }
        };
    }
}

