/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.serialization;

import com.yahoo.lang.MutableInteger;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MappedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.ConstantTensor;
import com.yahoo.tensor.functions.Slice;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class JsonFormat {
    public static byte[] encode(Tensor tensor, boolean shortForm, boolean directValues) {
        Slime slime = new Slime();
        Cursor root = null;
        if (!directValues) {
            root = slime.setObject();
            root.setString("type", tensor.type().toString());
        }
        if (shortForm) {
            if (tensor instanceof IndexedTensor) {
                IndexedTensor denseTensor = (IndexedTensor)tensor;
                Cursor parent = root == null ? slime.setArray() : root.setArray("values");
                JsonFormat.encodeValues(denseTensor, parent, new long[denseTensor.dimensionSizes().dimensions()], 0);
            } else if (tensor instanceof MappedTensor && tensor.type().dimensions().size() == 1) {
                Cursor parent = root == null ? slime.setObject() : root.setObject("cells");
                JsonFormat.encodeSingleDimensionCells((MappedTensor)tensor, parent);
            } else if (tensor instanceof MixedTensor && tensor.type().dimensions().stream().anyMatch(TensorType.Dimension::isMapped)) {
                boolean singleMapped;
                boolean bl = singleMapped = tensor.type().dimensions().stream().filter(TensorType.Dimension::isMapped).count() == 1L;
                Cursor parent = root == null ? (singleMapped ? slime.setObject() : slime.setArray()) : (singleMapped ? root.setObject("blocks") : root.setArray("blocks"));
                JsonFormat.encodeBlocks((MixedTensor)tensor, parent);
            } else {
                Cursor parent = root == null ? slime.setArray() : root.setArray("cells");
                JsonFormat.encodeCells(tensor, parent);
            }
            return com.yahoo.slime.JsonFormat.toJsonBytes(slime);
        }
        Cursor parent = root == null ? slime.setArray() : root.setArray("cells");
        JsonFormat.encodeCells(tensor, parent);
        return com.yahoo.slime.JsonFormat.toJsonBytes(slime);
    }

    public static byte[] encode(Tensor tensor) {
        return JsonFormat.encode(tensor, false, false);
    }

    @Deprecated
    public static byte[] encodeWithType(Tensor tensor) {
        return JsonFormat.encode(tensor, false, false);
    }

    @Deprecated
    public static byte[] encodeShortForm(Tensor tensor) {
        return JsonFormat.encode(tensor, true, false);
    }

    private static void encodeCells(Tensor tensor, Cursor cellsArray) {
        Iterator<Tensor.Cell> i = tensor.cellIterator();
        while (i.hasNext()) {
            Tensor.Cell cell = i.next();
            Cursor cellObject = cellsArray.addObject();
            JsonFormat.encodeAddress(tensor.type(), cell.getKey(), cellObject.setObject("address"));
            JsonFormat.setValue("value", cell.getValue(), tensor.type().valueType(), cellObject);
        }
    }

    private static void encodeSingleDimensionCells(MappedTensor tensor, Cursor cells) {
        if (tensor.type().dimensions().size() > 1) {
            throw new IllegalStateException("JSON encode of mapped tensor can only contain a single dimension");
        }
        tensor.cells().forEach((k, v) -> JsonFormat.setValue(k.label(0), v, tensor.type().valueType(), cells));
    }

    private static void encodeAddress(TensorType type, TensorAddress address, Cursor addressObject) {
        for (int i = 0; i < address.size(); ++i) {
            addressObject.setString(type.dimensions().get(i).name(), address.label(i));
        }
    }

    private static void encodeValues(IndexedTensor tensor, Cursor cursor, long[] indexes, int dimension) {
        DimensionSizes sizes = tensor.dimensionSizes();
        if (indexes.length == 0) {
            JsonFormat.addValue(tensor.get(0L), tensor.type().valueType(), cursor);
        } else {
            indexes[dimension] = 0L;
            while (indexes[dimension] < sizes.size(dimension)) {
                if (dimension < sizes.dimensions() - 1) {
                    JsonFormat.encodeValues(tensor, cursor.addArray(), indexes, dimension + 1);
                } else {
                    JsonFormat.addValue(tensor.get(indexes), tensor.type().valueType(), cursor);
                }
                int n = dimension;
                indexes[n] = indexes[n] + 1L;
            }
        }
    }

    private static void encodeBlocks(MixedTensor tensor, Cursor cursor) {
        List<TensorType.Dimension> mappedDimensions = tensor.type().dimensions().stream().filter(d -> d.isMapped()).map(d -> TensorType.Dimension.mapped(d.name())).toList();
        if (mappedDimensions.size() < 1) {
            throw new IllegalArgumentException("Should be ensured by caller");
        }
        TensorType mappedSubType = new TensorType.Builder(mappedDimensions).build();
        HashSet denseSubSpaceAddresses = new HashSet();
        tensor.cellIterator().forEachRemaining(cell -> denseSubSpaceAddresses.add(JsonFormat.subAddress(cell.getKey(), mappedSubType, tensor.type())));
        for (TensorAddress denseSubSpaceAddress : denseSubSpaceAddresses) {
            IndexedTensor denseSubspace = (IndexedTensor)JsonFormat.sliceSubAddress(tensor, denseSubSpaceAddress, mappedSubType);
            if (mappedDimensions.size() == 1) {
                JsonFormat.encodeValues(denseSubspace, cursor.setArray(denseSubSpaceAddress.label(0)), new long[denseSubspace.dimensionSizes().dimensions()], 0);
                continue;
            }
            Cursor block = cursor.addObject();
            JsonFormat.encodeAddress(mappedSubType, denseSubSpaceAddress, block.setObject("address"));
            JsonFormat.encodeValues(denseSubspace, block.setArray("values"), new long[denseSubspace.dimensionSizes().dimensions()], 0);
        }
    }

    private static void addValue(double value, TensorType.Value valueType, Cursor cursor) {
        if (valueType == TensorType.Value.INT8) {
            cursor.addLong((long)value);
        } else {
            cursor.addDouble(value);
        }
    }

    private static void setValue(String field, double value, TensorType.Value valueType, Cursor cursor) {
        if (valueType == TensorType.Value.INT8) {
            cursor.setLong(field, (long)value);
        } else {
            cursor.setDouble(field, value);
        }
    }

    private static TensorAddress subAddress(TensorAddress address, TensorType subType, TensorType origType) {
        TensorAddress.Builder builder = new TensorAddress.Builder(subType);
        for (TensorType.Dimension dim : subType.dimensions()) {
            builder.add(dim.name(), address.label(origType.indexOfDimension(dim.name()).orElseThrow(() -> new IllegalStateException("Could not find mapped dimension index"))));
        }
        return builder.build();
    }

    private static Tensor sliceSubAddress(Tensor tensor, TensorAddress subAddress, TensorType subType) {
        ArrayList sliceDims = new ArrayList(subAddress.size());
        for (int i = 0; i < subAddress.size(); ++i) {
            sliceDims.add(new Slice.DimensionValue(subType.dimensions().get(i).name(), subAddress.label(i)));
        }
        return new Slice(new ConstantTensor(tensor), sliceDims).evaluate();
    }

    public static Tensor decode(TensorType type, byte[] jsonTensorValue) {
        Tensor.Builder builder = Tensor.Builder.of(type);
        Cursor root = new JsonDecoder().decode(new Slime(), jsonTensorValue).get();
        if (root.field("cells").valid() && !JsonFormat.primitiveContent(root.field("cells"))) {
            JsonFormat.decodeCells(root.field("cells"), builder);
        } else if (root.field("values").valid() && builder.type().dimensions().stream().allMatch(d -> d.isIndexed())) {
            JsonFormat.decodeValuesAtTop(root.field("values"), builder);
        } else if (root.field("blocks").valid()) {
            JsonFormat.decodeBlocks(root.field("blocks"), builder);
        } else {
            JsonFormat.decodeDirectValue(root, builder);
        }
        return builder.build();
    }

    private static boolean primitiveContent(Inspector cellsValue) {
        if (cellsValue.type() == Type.DOUBLE) {
            return true;
        }
        if (cellsValue.type() == Type.LONG) {
            return true;
        }
        return cellsValue.type() == Type.ARRAY && cellsValue.entries() > 0 && (cellsValue.entry(0).type() == Type.DOUBLE || cellsValue.entry(0).type() == Type.LONG);
    }

    private static void decodeCells(Inspector cells, Tensor.Builder builder) {
        if (cells.type() == Type.ARRAY) {
            cells.traverse((__, cell) -> JsonFormat.decodeCell(cell, builder));
        } else if (cells.type() == Type.OBJECT) {
            cells.traverse((key, value) -> JsonFormat.decodeSingleDimensionCell(key, value, builder));
        } else {
            throw new IllegalArgumentException("Excepted 'cells' to contain an array or object, not " + cells.type());
        }
    }

    private static void decodeCell(Inspector cell, Tensor.Builder builder) {
        TensorAddress address = JsonFormat.decodeAddress(cell.field("address"), builder.type());
        Inspector value = cell.field("value");
        if (value.type() != Type.LONG && value.type() != Type.DOUBLE) {
            throw new IllegalArgumentException("Excepted a cell to contain a numeric value called 'value'");
        }
        builder.cell(address, value.asDouble());
    }

    private static void decodeSingleDimensionCell(String key, Inspector value, Tensor.Builder builder) {
        builder.cell(JsonFormat.asAddress(key, builder.type()), JsonFormat.decodeNumeric(value));
    }

    private static void decodeValuesAtTop(Inspector values, Tensor.Builder builder) {
        JsonFormat.decodeNestedValues(values, builder, new MutableInteger(0));
    }

    private static void decodeNestedValues(Inspector values, Tensor.Builder builder, MutableInteger index) {
        if (!(builder instanceof IndexedTensor.BoundBuilder)) {
            throw new IllegalArgumentException("An array of values can only be used with a dense tensor. Use a map instead");
        }
        IndexedTensor.BoundBuilder indexedBuilder = (IndexedTensor.BoundBuilder)builder;
        if (values.type() == Type.STRING) {
            double[] decoded = JsonFormat.decodeHexString(values.asString(), builder.type().valueType());
            if (decoded.length == 0) {
                throw new IllegalArgumentException("The values string does not contain any values");
            }
            for (int i = 0; i < decoded.length; ++i) {
                indexedBuilder.cellByDirectIndex((long)i, decoded[i]);
            }
            return;
        }
        if (values.type() != Type.ARRAY) {
            throw new IllegalArgumentException("Excepted values to be an array, not " + values.type());
        }
        if (values.entries() == 0) {
            throw new IllegalArgumentException("The values array does not contain any values");
        }
        values.traverse((__, value) -> {
            if (value.type() == Type.ARRAY) {
                JsonFormat.decodeNestedValues(value, builder, index);
            } else if (value.type() == Type.LONG || value.type() == Type.DOUBLE) {
                indexedBuilder.cellByDirectIndex((long)index.next(), value.asDouble());
            } else {
                throw new IllegalArgumentException("Excepted the values array to contain numbers or nested arrays, not " + value.type());
            }
        });
    }

    private static void decodeBlocks(Inspector values, Tensor.Builder builder) {
        if (!(builder instanceof MixedTensor.BoundBuilder)) {
            throw new IllegalArgumentException("Blocks of values can only be used with mixed (sparse and dense) tensors.Use an array of cell values instead.");
        }
        MixedTensor.BoundBuilder mixedBuilder = (MixedTensor.BoundBuilder)builder;
        if (values.type() == Type.ARRAY) {
            values.traverse((__, value) -> JsonFormat.decodeBlock(value, mixedBuilder));
        } else if (values.type() == Type.OBJECT) {
            values.traverse((key, value) -> JsonFormat.decodeSingleDimensionBlock(key, value, mixedBuilder));
        } else {
            throw new IllegalArgumentException("Excepted the block to contain an array or object, not " + values.type());
        }
    }

    private static void decodeBlock(Inspector block, MixedTensor.BoundBuilder mixedBuilder) {
        if (block.type() != Type.OBJECT) {
            throw new IllegalArgumentException("Expected an item in a blocks array to be an object, not " + block.type());
        }
        mixedBuilder.block(JsonFormat.decodeAddress(block.field("address"), mixedBuilder.type().mappedSubtype()), JsonFormat.decodeValuesInBlock(block.field("values"), mixedBuilder));
    }

    private static void decodeDirectValue(Inspector root, Tensor.Builder builder) {
        boolean hasIndexed = builder.type().dimensions().stream().anyMatch(TensorType.Dimension::isIndexed);
        boolean hasMapped = builder.type().dimensions().stream().anyMatch(TensorType.Dimension::isMapped);
        if (JsonFormat.isArrayOfObjects(root)) {
            JsonFormat.decodeCells(root, builder);
        } else if (!hasMapped) {
            JsonFormat.decodeValuesAtTop(root, builder);
        } else if (hasMapped && hasIndexed) {
            JsonFormat.decodeBlocks(root, builder);
        } else {
            JsonFormat.decodeCells(root, builder);
        }
    }

    private static boolean isArrayOfObjects(Inspector inspector) {
        if (inspector.type() != Type.ARRAY) {
            return false;
        }
        if (inspector.entries() == 0) {
            return false;
        }
        Inspector firstItem = inspector.entry(0);
        if (firstItem.type() == Type.ARRAY) {
            return JsonFormat.isArrayOfObjects(firstItem);
        }
        return firstItem.type() == Type.OBJECT;
    }

    private static void decodeSingleDimensionBlock(String key, Inspector value, MixedTensor.BoundBuilder mixedBuilder) {
        if (value.type() != Type.ARRAY) {
            throw new IllegalArgumentException("Expected an item in a blocks array to be an array, not " + value.type());
        }
        mixedBuilder.block(JsonFormat.asAddress(key, mixedBuilder.type().mappedSubtype()), JsonFormat.decodeValuesInBlock(value, mixedBuilder));
    }

    private static byte decodeHex(String input, int index) {
        int d = Character.digit(input.charAt(index), 16);
        if (d < 0) {
            throw new IllegalArgumentException("Invalid digit '" + input.charAt(index) + "' at index " + index + " in input " + input);
        }
        return (byte)d;
    }

    private static double[] decodeHexStringAsBytes(String input) {
        int l = input.length() / 2;
        double[] result = new double[l];
        int idx = 0;
        for (int i = 0; i < l; ++i) {
            byte v = JsonFormat.decodeHex(input, idx++);
            v = (byte)(v << 4);
            v = (byte)(v + JsonFormat.decodeHex(input, idx++));
            result[i] = v;
        }
        return result;
    }

    private static double[] decodeHexStringAsBFloat16s(String input) {
        int l = input.length() / 4;
        double[] result = new double[l];
        int idx = 0;
        for (int i = 0; i < l; ++i) {
            int v = JsonFormat.decodeHex(input, idx++);
            v <<= 4;
            v += JsonFormat.decodeHex(input, idx++);
            v <<= 4;
            v += JsonFormat.decodeHex(input, idx++);
            v <<= 4;
            v += JsonFormat.decodeHex(input, idx++);
            result[i] = Float.intBitsToFloat(v <<= 16);
        }
        return result;
    }

    private static double[] decodeHexStringAsFloats(String input) {
        int l = input.length() / 8;
        double[] result = new double[l];
        int idx = 0;
        for (int i = 0; i < l; ++i) {
            int v = 0;
            for (int j = 0; j < 8; ++j) {
                v <<= 4;
                v += JsonFormat.decodeHex(input, idx++);
            }
            result[i] = Float.intBitsToFloat(v);
        }
        return result;
    }

    private static double[] decodeHexStringAsDoubles(String input) {
        int l = input.length() / 16;
        double[] result = new double[l];
        int idx = 0;
        for (int i = 0; i < l; ++i) {
            long v = 0L;
            for (int j = 0; j < 16; ++j) {
                v <<= 4;
                v += (long)JsonFormat.decodeHex(input, idx++);
            }
            result[i] = Double.longBitsToDouble(v);
        }
        return result;
    }

    public static double[] decodeHexString(String input, TensorType.Value valueType) {
        return switch (valueType) {
            default -> throw new IncompatibleClassChangeError();
            case TensorType.Value.INT8 -> JsonFormat.decodeHexStringAsBytes(input);
            case TensorType.Value.BFLOAT16 -> JsonFormat.decodeHexStringAsBFloat16s(input);
            case TensorType.Value.FLOAT -> JsonFormat.decodeHexStringAsFloats(input);
            case TensorType.Value.DOUBLE -> JsonFormat.decodeHexStringAsDoubles(input);
        };
    }

    private static double[] decodeValuesInBlock(Inspector valuesField, MixedTensor.BoundBuilder mixedBuilder) {
        double[] values = new double[(int)mixedBuilder.denseSubspaceSize()];
        if (valuesField.type() == Type.ARRAY) {
            if (valuesField.entries() == 0) {
                throw new IllegalArgumentException("The block value array does not contain any values");
            }
            valuesField.traverse((index, value) -> {
                values[index] = JsonFormat.decodeNumeric(value);
            });
        } else if (valuesField.type() == Type.STRING) {
            double[] decoded = JsonFormat.decodeHexString(valuesField.asString(), mixedBuilder.type().valueType());
            if (decoded.length == 0) {
                throw new IllegalArgumentException("The block value string does not contain any values");
            }
            for (int i = 0; i < decoded.length; ++i) {
                values[i] = decoded[i];
            }
        } else {
            throw new IllegalArgumentException("Expected a block to contain an array of values");
        }
        return values;
    }

    private static TensorAddress decodeAddress(Inspector addressField, TensorType type) {
        if (addressField.type() != Type.OBJECT) {
            throw new IllegalArgumentException("Expected an 'address' object, not " + addressField.type());
        }
        TensorAddress.Builder builder = new TensorAddress.Builder(type);
        addressField.traverse((dimension, label) -> builder.add(dimension, label.asString()));
        return builder.build();
    }

    private static TensorAddress asAddress(String label, TensorType type) {
        if (type.dimensions().size() != 1) {
            throw new IllegalArgumentException("Expected a tensor with a single dimension but got " + type);
        }
        return new TensorAddress.Builder(type).add(type.dimensions().get(0).name(), label).build();
    }

    private static double decodeNumeric(Inspector numericField) {
        if (numericField.type() != Type.LONG && numericField.type() != Type.DOUBLE) {
            throw new IllegalArgumentException("Excepted a number, not " + numericField.type());
        }
        return numericField.asDouble();
    }
}

