/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.yahoo.text.Utf8;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class GrowableByteBuffer
implements Comparable<GrowableByteBuffer> {
    public static final int DEFAULT_BASE_SIZE = 65536;
    public static final float DEFAULT_GROW_FACTOR = 2.0f;
    private ByteBuffer buffer;
    private float growFactor;
    private int mark = -1;

    public GrowableByteBuffer() {
        this(65536, 2.0f);
    }

    public GrowableByteBuffer(int baseSize, float growFactor) {
        this.setGrowFactor(growFactor);
        if (baseSize < 16) {
            baseSize = 16;
        }
        this.buffer = ByteBuffer.allocate(baseSize);
    }

    public GrowableByteBuffer(int baseSize) {
        this(baseSize, 2.0f);
    }

    public GrowableByteBuffer(ByteBuffer buffer) {
        this(buffer, 2.0f);
    }

    public GrowableByteBuffer(ByteBuffer buffer, float growFactor) {
        this.buffer = buffer;
        this.setGrowFactor(growFactor);
    }

    public float getGrowFactor() {
        return this.growFactor;
    }

    public void setGrowFactor(float growFactor) {
        if (growFactor <= 1.0f) {
            throw new IllegalArgumentException("Growth factor must be greater than 1.00f, otherwise buffer will never grow!");
        }
        this.growFactor = growFactor;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public void grow(int newSize) {
        ByteBuffer newByteBuf = this.buffer.isDirect() ? ByteBuffer.allocateDirect(newSize) : ByteBuffer.allocate(newSize);
        newByteBuf.order(this.buffer.order());
        int oldPos = this.buffer.position();
        newByteBuf.position(0);
        this.buffer.flip();
        newByteBuf.put(this.buffer);
        newByteBuf.position(oldPos);
        if (this.mark >= 0) {
            newByteBuf.position(this.mark);
            newByteBuf.mark();
            newByteBuf.position(oldPos);
        }
        this.buffer = newByteBuf;
    }

    private void accomodate(int putSize) {
        int bufPos = this.buffer.position();
        int bufSize = this.buffer.capacity();
        int bufRem = bufSize - bufPos;
        if (bufRem >= putSize) {
            return;
        }
        while (bufRem < putSize) {
            bufSize = (int)((double)((float)bufSize * this.growFactor) + 100.0);
            bufRem = bufSize - bufPos;
        }
        this.grow(bufSize);
    }

    public void putInt2_4_8Bytes(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("Cannot encode negative number.");
        }
        if (number > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Cannot encode number larger than 2^62.");
        }
        if (number < 32768L) {
            this.putShort((short)number);
        } else if (number < 0x40000000L) {
            this.putInt((int)number | Integer.MIN_VALUE);
        } else {
            this.putLong(number | 0xC000000000000000L);
        }
    }

    public void putInt2_4_8BytesAs4(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("Cannot encode negative number.");
        }
        if (number > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode number larger than 2^31-1.");
        }
        this.putInt((int)number | Integer.MIN_VALUE);
    }

    public long getInt2_4_8Bytes() {
        byte flagByte = this.get();
        this.position(this.position() - 1);
        if ((flagByte & 0x80) != 0) {
            if ((flagByte & 0x40) != 0) {
                return this.getLong() & 0x3FFFFFFFFFFFFFFFL;
            }
            return this.getInt() & 0x3FFFFFFF;
        }
        return this.getShort();
    }

    public static int getSerializedSize2_4_8Bytes(long number) {
        if (number < 0L) {
            throw new IllegalArgumentException("Cannot encode negative number.");
        }
        if (number > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Cannot encode number larger than 2^62.");
        }
        if (number < 32768L) {
            return 2;
        }
        if (number < 0x40000000L) {
            return 4;
        }
        return 8;
    }

    public void putInt1_2_4Bytes(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Cannot encode negative number");
        }
        if (number > 0x3FFFFFFF) {
            throw new IllegalArgumentException("Cannot encode number larger than 2^30.");
        }
        if (number < 128) {
            this.put((byte)number);
        } else if (number < 16384) {
            this.putShort((short)((short)number | Short.MIN_VALUE));
        } else {
            this.putInt(number | 0xC0000000);
        }
    }

    public void putInt1_2_4BytesAs4(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Cannot encode negative number");
        }
        if (number > 0x3FFFFFFF) {
            throw new IllegalArgumentException("Cannot encode number larger than 2^30.");
        }
        this.putInt(number | 0xC0000000);
    }

    public int getInt1_2_4Bytes() {
        byte flagByte = this.get();
        this.position(this.position() - 1);
        if ((flagByte & 0x80) != 0) {
            if ((flagByte & 0x40) != 0) {
                return this.getInt() & 0x3FFFFFFF;
            }
            return this.getShort() & 0x3FFF;
        }
        return this.get();
    }

    public static int getSerializedSize1_2_4Bytes(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Cannot encode negative number");
        }
        if (number > 0x3FFFFFFF) {
            throw new IllegalArgumentException("Cannot encode number larger than 2^30.");
        }
        if (number < 128) {
            return 1;
        }
        if (number < 16384) {
            return 2;
        }
        return 4;
    }

    public void putInt1_4Bytes(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Cannot encode negative number");
        }
        if (number < 128) {
            this.put((byte)number);
        } else {
            this.putInt(number | Integer.MIN_VALUE);
        }
    }

    public void putInt1_4BytesAs4(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Cannot encode negative number");
        }
        this.putInt(number | Integer.MIN_VALUE);
    }

    public int getInt1_4Bytes() {
        byte flagByte = this.get();
        this.position(this.position() - 1);
        if ((flagByte & 0x80) != 0) {
            return this.getInt() & Integer.MAX_VALUE;
        }
        return this.get();
    }

    public void putUtf8String(String value) {
        byte[] stringBytes = Utf8.toBytes(value);
        this.putInt1_4Bytes(stringBytes.length);
        this.put(stringBytes);
    }

    public String getUtf8String() {
        int stringLength = this.getInt1_4Bytes();
        byte[] stringBytes = new byte[stringLength];
        this.get(stringBytes);
        return Utf8.toString(stringBytes);
    }

    public static int getSerializedSize1_4Bytes(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("Cannot encode negative number");
        }
        if (number < 128) {
            return 1;
        }
        return 4;
    }

    public static GrowableByteBuffer allocate(int capacity) {
        return new GrowableByteBuffer(ByteBuffer.allocate(capacity));
    }

    public static GrowableByteBuffer allocate(int capacity, float growFactor) {
        return new GrowableByteBuffer(ByteBuffer.allocate(capacity), growFactor);
    }

    public static GrowableByteBuffer allocateDirect(int capacity) {
        return new GrowableByteBuffer(ByteBuffer.allocateDirect(capacity));
    }

    public static GrowableByteBuffer allocateDirect(int capacity, float growFactor) {
        return new GrowableByteBuffer(ByteBuffer.allocateDirect(capacity), growFactor);
    }

    public final byte[] array() {
        return this.buffer.array();
    }

    public final int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public CharBuffer asCharBuffer() {
        return this.buffer.asCharBuffer();
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.buffer.asDoubleBuffer();
    }

    public FloatBuffer asFloatBuffer() {
        return this.buffer.asFloatBuffer();
    }

    public IntBuffer asIntBuffer() {
        return this.buffer.asIntBuffer();
    }

    public LongBuffer asLongBuffer() {
        return this.buffer.asLongBuffer();
    }

    public GrowableByteBuffer asReadOnlyBuffer() {
        return new GrowableByteBuffer(this.buffer.asReadOnlyBuffer(), this.growFactor);
    }

    public ShortBuffer asShortBuffer() {
        return this.buffer.asShortBuffer();
    }

    public GrowableByteBuffer compact() {
        this.buffer.compact();
        return this;
    }

    @Override
    public int compareTo(GrowableByteBuffer that) {
        return this.buffer.compareTo(that.buffer);
    }

    public GrowableByteBuffer duplicate() {
        return new GrowableByteBuffer(this.buffer.duplicate(), this.growFactor);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GrowableByteBuffer)) {
            return false;
        }
        GrowableByteBuffer rhs = (GrowableByteBuffer)obj;
        return this.buffer.equals(rhs.buffer);
    }

    public byte get() {
        return this.buffer.get();
    }

    public GrowableByteBuffer get(byte[] dst) {
        this.buffer.get(dst);
        return this;
    }

    public GrowableByteBuffer get(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
        return this;
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public char getChar() {
        return this.buffer.getChar();
    }

    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public GrowableByteBuffer order(ByteOrder bo) {
        this.buffer.order(bo);
        return this;
    }

    public GrowableByteBuffer put(byte b) {
        try {
            this.buffer.put(b);
        }
        catch (BufferOverflowException e) {
            this.accomodate(1);
            this.buffer.put(b);
        }
        return this;
    }

    public GrowableByteBuffer put(byte[] src) {
        this.accomodate(src.length);
        this.buffer.put(src);
        return this;
    }

    public GrowableByteBuffer put(byte[] src, int offset, int length) {
        this.accomodate(length);
        this.buffer.put(src, offset, length);
        return this;
    }

    public GrowableByteBuffer put(ByteBuffer src) {
        this.accomodate(src.remaining());
        this.buffer.put(src);
        return this;
    }

    public GrowableByteBuffer put(GrowableByteBuffer src) {
        this.accomodate(src.remaining());
        this.buffer.put(src.buffer);
        return this;
    }

    public GrowableByteBuffer put(int index, byte b) {
        try {
            this.buffer.put(index, b);
        }
        catch (IndexOutOfBoundsException e) {
            this.accomodate(1);
            this.buffer.put(index, b);
        }
        return this;
    }

    public GrowableByteBuffer putChar(char value) {
        try {
            this.buffer.putChar(value);
        }
        catch (BufferOverflowException e) {
            this.accomodate(2);
            this.buffer.putChar(value);
        }
        return this;
    }

    public GrowableByteBuffer putChar(int index, char value) {
        try {
            this.buffer.putChar(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            this.accomodate(2);
            this.buffer.putChar(index, value);
        }
        return this;
    }

    public GrowableByteBuffer putDouble(double value) {
        try {
            this.buffer.putDouble(value);
        }
        catch (BufferOverflowException e) {
            this.accomodate(8);
            this.buffer.putDouble(value);
        }
        return this;
    }

    public GrowableByteBuffer putDouble(int index, double value) {
        try {
            this.buffer.putDouble(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            this.accomodate(8);
            this.buffer.putDouble(index, value);
        }
        return this;
    }

    public GrowableByteBuffer putFloat(float value) {
        try {
            this.buffer.putFloat(value);
        }
        catch (BufferOverflowException e) {
            this.accomodate(4);
            this.buffer.putFloat(value);
        }
        return this;
    }

    public GrowableByteBuffer putFloat(int index, float value) {
        try {
            this.buffer.putFloat(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            this.accomodate(4);
            this.buffer.putFloat(index, value);
        }
        return this;
    }

    public GrowableByteBuffer putInt(int value) {
        try {
            this.buffer.putInt(value);
        }
        catch (BufferOverflowException e) {
            this.accomodate(4);
            this.buffer.putInt(value);
        }
        return this;
    }

    public GrowableByteBuffer putInt(int index, int value) {
        try {
            this.buffer.putInt(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            this.accomodate(4);
            this.buffer.putInt(index, value);
        }
        return this;
    }

    public GrowableByteBuffer putLong(int index, long value) {
        try {
            this.buffer.putLong(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            this.accomodate(8);
            this.buffer.putLong(index, value);
        }
        return this;
    }

    public GrowableByteBuffer putLong(long value) {
        try {
            this.buffer.putLong(value);
        }
        catch (BufferOverflowException e) {
            this.accomodate(8);
            this.buffer.putLong(value);
        }
        return this;
    }

    public GrowableByteBuffer putShort(int index, short value) {
        try {
            this.buffer.putShort(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            this.accomodate(2);
            this.buffer.putShort(index, value);
        }
        return this;
    }

    public GrowableByteBuffer putShort(short value) {
        try {
            this.buffer.putShort(value);
        }
        catch (BufferOverflowException e) {
            this.accomodate(2);
            this.buffer.putShort(value);
        }
        return this;
    }

    public GrowableByteBuffer slice() {
        ByteBuffer b = this.buffer.slice();
        return new GrowableByteBuffer(b, this.growFactor);
    }

    public String toString() {
        return "GrowableByteBuffer[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + " grow=" + this.growFactor + "]";
    }

    public static GrowableByteBuffer wrap(byte[] array) {
        return new GrowableByteBuffer(ByteBuffer.wrap(array));
    }

    public static GrowableByteBuffer wrap(byte[] array, float growFactor) {
        return new GrowableByteBuffer(ByteBuffer.wrap(array), growFactor);
    }

    public static GrowableByteBuffer wrap(byte[] array, int offset, int length) {
        return new GrowableByteBuffer(ByteBuffer.wrap(array, offset, length));
    }

    public static GrowableByteBuffer wrap(byte[] array, int offset, int length, float growFactor) {
        return new GrowableByteBuffer(ByteBuffer.wrap(array, offset, length), growFactor);
    }

    public final int capacity() {
        return this.buffer.capacity();
    }

    public final void clear() {
        this.buffer.clear();
        this.mark = -1;
    }

    public final void flip() {
        this.buffer.flip();
        this.mark = -1;
    }

    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public final boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public final int limit() {
        return this.buffer.limit();
    }

    public final void limit(int newLimit) {
        this.buffer.limit(newLimit);
        if (this.mark > newLimit) {
            this.mark = -1;
        }
    }

    public final void mark() {
        this.buffer.mark();
        this.mark = this.position();
    }

    public final int position() {
        return this.buffer.position();
    }

    public final void position(int newPosition) {
        this.buffer.position(newPosition);
        if (this.mark > newPosition) {
            this.mark = -1;
        }
    }

    public final int remaining() {
        return this.buffer.remaining();
    }

    public final void reset() {
        this.buffer.reset();
    }

    public final void rewind() {
        this.buffer.rewind();
        this.mark = -1;
    }
}

