/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public interface Timer {
    public static final Timer monotonic = () -> TimeUnit.NANOSECONDS.toMillis(System.nanoTime());

    public long milliTime();

    public static Timer wrap(final Clock original) {
        return new Timer(){
            private final Clock clock;
            {
                this.clock = original;
            }

            @Override
            public long milliTime() {
                return this.clock.millis();
            }
        };
    }

    default public Instant instant() {
        return Instant.ofEpochMilli(this.milliTime());
    }
}

