/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

final class DecodeIndex {
    static final int initial_capacity = 16;
    private long[] data = new long[16];
    private int reserved = 0;

    DecodeIndex() {
    }

    private int adjustSize(int minSize) {
        int capacity;
        for (capacity = 16; capacity < minSize; capacity <<= 1) {
        }
        return capacity;
    }

    int reserve(int n) {
        int offset = this.reserved;
        if (this.reserved + n > this.data.length) {
            long[] old = this.data;
            this.data = new long[this.adjustSize(this.reserved + n)];
            System.arraycopy(old, 0, this.data, 0, this.reserved);
        }
        this.reserved += n;
        return offset;
    }

    int size() {
        return this.reserved;
    }

    void set(int idx, int byteOffset, int firstChild, int extBits) {
        this.data[idx] = (long)(byteOffset & Integer.MAX_VALUE) << 33 | (long)(firstChild & Integer.MAX_VALUE) << 2 | (long)(extBits & 3);
    }

    int getByteOffset(int idx) {
        return (int)(this.data[idx] >> 33) & Integer.MAX_VALUE;
    }

    int getFirstChild(int idx) {
        return (int)(this.data[idx] >> 2) & Integer.MAX_VALUE;
    }

    int getExtBits(int idx) {
        return (int)this.data[idx] & 3;
    }
}

