/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.lang;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;

public class CachedSupplier<T>
implements Supplier<T> {
    private final Object monitor = new Object();
    private final Supplier<T> delegate;
    private final Duration period;
    private final Clock clock;
    private Instant nextRefresh;
    private volatile T value;

    public CachedSupplier(Supplier<T> delegate, Duration period) {
        this(delegate, period, Clock.systemUTC());
    }

    CachedSupplier(Supplier<T> delegate, Duration period, Clock clock) {
        this.delegate = delegate;
        this.period = period;
        this.clock = clock;
        this.nextRefresh = Instant.MIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.clock.instant().isAfter(this.nextRefresh)) {
                this.value = this.delegate.get();
                this.nextRefresh = this.clock.instant().plus(this.period);
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.monitor;
        synchronized (object) {
            this.nextRefresh = Instant.MIN;
        }
    }
}

