/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.ini;

import com.yahoo.yolean.Exceptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;

public record Ini(SortedMap<String, SortedMap<String, String>> entries) {
    private static final char ESCAPE_C = '\\';
    private static final char QUOTE_C = '\"';
    private static final String QUOTE = String.valueOf('\"');

    public Ini {
        TreeMap<String, SortedMap<String, String>> copy = new TreeMap<String, SortedMap<String, String>>(entries);
        copy.replaceAll((k, v) -> Collections.unmodifiableSortedMap(new TreeMap((SortedMap)copy.get(k))));
        entries = Collections.unmodifiableSortedMap(copy);
    }

    public void write(OutputStream output) {
        PrintStream printer = new PrintStream(output, true);
        this.entries.forEach((section, sectionEntries) -> {
            if (!section.isEmpty()) {
                printer.printf("[%s]\n", section);
            }
            sectionEntries.forEach((key, value) -> printer.printf("%s = %s\n", key, Ini.quote(value)));
            if (!section.equals(this.entries.lastKey())) {
                printer.println();
            }
        });
    }

    public static Ini parse(InputStream input) {
        TreeMap<String, SortedMap<String, String>> entries = new TreeMap<String, SortedMap<String, String>>();
        Scanner scanner = new Scanner(input, StandardCharsets.UTF_8);
        String section = "";
        int lineNum = 0;
        while (scanner.hasNextLine()) {
            ++lineNum;
            String line = scanner.nextLine().trim();
            if (line.isEmpty() || Ini.isComment(line)) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                section = line.substring(1, line.length() - 1);
                continue;
            }
            try {
                Entry entry = Entry.parse(line);
                entries.putIfAbsent(section, new TreeMap());
                String prevValue = entries.computeIfAbsent(section, k -> new TreeMap()).put(entry.key, entry.value);
                if (prevValue == null) continue;
                throw new IllegalArgumentException("Key '" + entry.key + "' duplicated in section '" + section + "'");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid entry on line " + lineNum + ": '" + line + "': " + Exceptions.toMessageString((Throwable)e));
            }
        }
        return new Ini(entries);
    }

    private static boolean isComment(String s) {
        return s.startsWith(";") || s.startsWith("#");
    }

    private static boolean requiresQuoting(String s) {
        return s.isEmpty() || s.contains(QUOTE) || !s.equals(s.trim());
    }

    private static boolean unescapedQuoteAt(int index, String s) {
        return s.charAt(index) == '\"' && (index == 0 || s.charAt(index - 1) != '\\');
    }

    private static String quote(String s) {
        if (!Ini.requiresQuoting(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(QUOTE);
        for (int i = 0; i < s.length(); ++i) {
            if (Ini.unescapedQuoteAt(i, s)) {
                sb.append('\\');
            }
            sb.append(s.charAt(i));
        }
        sb.append(QUOTE);
        return sb.toString();
    }

    private record Entry(String key, String value) {
        static Entry parse(String s) {
            int equalIndex = s.indexOf(61);
            if (equalIndex < 0) {
                throw new IllegalArgumentException("Expected key=[value]");
            }
            String key = s.substring(0, equalIndex).trim();
            String value = s.substring(equalIndex + 1).trim();
            return new Entry(key, Entry.dequote(value));
        }

        private static String dequote(String s) {
            boolean quoted = s.startsWith(QUOTE);
            int end = s.length();
            boolean closeQuote = false;
            for (int i = 0; i < s.length(); ++i) {
                String trailing;
                boolean startComment;
                closeQuote = quoted && i > 0 && Ini.unescapedQuoteAt(i, s);
                boolean bl = startComment = !quoted && Ini.isComment(String.valueOf(s.charAt(i)));
                if (!closeQuote && !startComment) continue;
                end = i;
                if (!quoted || end >= s.length() - 1 || Ini.isComment(trailing = s.substring(end + 1).trim())) break;
                throw new IllegalArgumentException("Additional character(s) after end quote at column " + end);
            }
            if (quoted && !closeQuote) {
                throw new IllegalArgumentException("Missing closing quote");
            }
            int start = quoted ? 1 : 0;
            String value = s.substring(start, end);
            return quoted ? value : value.trim();
        }
    }
}

