/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class NativeIO {
    private static final Logger logger = Logger.getLogger(NativeIO.class.getName());
    private static final String DISABLE_NATIVE_IO = "DISABLE_NATIVE_IO";
    private static final int POSIX_FADV_DONTNEED = 4;
    private static final InitResult fdField = new InitResult();

    private static native int posix_fadvise(int var0, long var1, long var3, int var5) throws LastErrorException;

    public NativeIO() {
        if (!fdField.isInitialized()) {
            if (fdField.isEnabled()) {
                logger.warning("Native IO not possible due to " + this.getError().getMessage());
            } else {
                logger.info("Native IO has been disable explicit via system property DISABLE_NATIVE_IO");
            }
        }
    }

    public boolean valid() {
        return fdField.isInitialized();
    }

    public Throwable getError() {
        return fdField.getError();
    }

    public void dropPartialFileFromCache(FileDescriptor fd, long offset, long len, boolean sync) {
        if (sync) {
            try {
                fd.sync();
            }
            catch (SyncFailedException e) {
                logger.warning("Sync failed while dropping cache: " + e.getMessage());
            }
        }
        if (this.valid()) {
            NativeIO.posix_fadvise(fdField.getNativeFD(fd), offset, len, 4);
        }
    }

    public void dropFileFromCache(FileDescriptor fd) {
        this.dropPartialFileFromCache(fd, 0L, 0L, true);
    }

    public void dropFileFromCache(File file) {
        try {
            this.dropFileFromCache(new FileInputStream(file).getFD());
        }
        catch (FileNotFoundException e) {
            logger.fine("No point in dropping a non-existing file from the buffer cache: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InitResult {
        private final boolean initialized;
        private final boolean enabled;
        private final Field fdField;
        private final Throwable initError;

        InitResult() {
            boolean initComplete = false;
            boolean disabled = true;
            Field field = null;
            Throwable exception = null;
            try {
                if (Platform.isLinux()) {
                    disabled = System.getenv().containsKey(NativeIO.DISABLE_NATIVE_IO);
                    if (!disabled) {
                        Native.register((String)Platform.C_LIBRARY_NAME);
                        field = InitResult.getField(FileDescriptor.class, "fd");
                        initComplete = true;
                    }
                } else {
                    exception = new RuntimeException("Platform is uns\u00fapported. Only supported on linux.");
                }
            }
            catch (Throwable throwable) {
                exception = throwable;
            }
            this.initialized = initComplete;
            this.enabled = !disabled;
            this.initError = exception;
            this.fdField = field;
        }

        private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }

        boolean isInitialized() {
            return this.initialized;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        Throwable getError() {
            return this.initError;
        }

        int getNativeFD(FileDescriptor fd) {
            try {
                return this.fdField.getInt(fd);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

