/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.compress;

import com.yahoo.compress.ZstdCompressor;
import java.io.IOException;
import java.io.OutputStream;

public class ZstdOutputStream
extends OutputStream {
    private final ZstdCompressor compressor = new ZstdCompressor();
    public static final int DEFAULT_INPUT_BUFFER_SIZE = 8192;
    private final OutputStream out;
    private final byte[] inputBuffer;
    private final byte[] outputBuffer;
    private int inputPosition = 0;
    private boolean isClosed = false;

    public ZstdOutputStream(OutputStream out, int inputBufferSize) {
        this.out = out;
        this.inputBuffer = new byte[inputBufferSize];
        this.outputBuffer = new byte[ZstdCompressor.getMaxCompressedLength(inputBufferSize)];
    }

    public ZstdOutputStream(OutputStream out) {
        this(out, 8192);
    }

    @Override
    public void write(int b) throws IOException {
        this.throwIfClosed();
        this.inputBuffer[this.inputPosition++] = (byte)b;
        this.flushIfFull();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.throwIfClosed();
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.throwIfClosed();
        int end = off + len;
        while (off < end) {
            int copyLength = Math.min(end - off, this.inputBuffer.length - this.inputPosition);
            System.arraycopy(b, off, this.inputBuffer, this.inputPosition, copyLength);
            off += copyLength;
            this.inputPosition += copyLength;
            this.flushIfFull();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.throwIfClosed();
        this.flush();
        this.out.close();
        this.isClosed = true;
    }

    private void flushInternal() throws IOException {
        this.throwIfClosed();
        int compressedLength = this.compressor.compress(this.inputBuffer, 0, this.inputPosition, this.outputBuffer, 0, this.outputBuffer.length);
        this.out.write(this.outputBuffer, 0, compressedLength);
        this.inputPosition = 0;
    }

    private void flushIfFull() throws IOException {
        if (this.inputPosition == this.inputBuffer.length) {
            this.flushInternal();
        }
    }

    private void throwIfClosed() {
        if (this.isClosed) {
            throw new IllegalArgumentException("Output stream is already closed");
        }
    }
}

