/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.time;

import com.yahoo.concurrent.UncheckedTimeoutException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

public class TimeBudget {
    private final Clock clock;
    private final Instant start;
    private final Optional<Duration> timeout;

    public static TimeBudget fromNow(Clock clock, Duration timeout) {
        return new TimeBudget(clock, clock.instant(), Optional.of(timeout));
    }

    public static TimeBudget from(Clock clock, Instant start, Optional<Duration> timeout) {
        return new TimeBudget(clock, start, timeout);
    }

    private TimeBudget(Clock clock, Instant start, Optional<Duration> timeout) {
        this.clock = clock;
        this.start = start;
        this.timeout = timeout.map(TimeBudget::makeNonNegative);
    }

    public Duration timePassed() {
        return TimeBudget.nonNegativeBetween(this.start, this.clock.instant());
    }

    public Optional<Duration> originalTimeout() {
        return this.timeout;
    }

    public Optional<Instant> deadline() {
        return this.timeout.map(this.start::plus);
    }

    public Optional<Duration> timeLeftOrThrow() {
        return this.timeout.map(timeout -> {
            Duration passed = this.timePassed();
            Duration left = timeout.minus(passed);
            if (left.toMillis() <= 0L) {
                throw new UncheckedTimeoutException("Time since start " + passed + " exceeds timeout " + this.timeout);
            }
            return left;
        });
    }

    public Optional<Duration> timeLeft() {
        return this.timeout.map(timeout -> timeout.minus(this.timePassed()));
    }

    public TimeBudget timeLeftAsTimeBudget() {
        Instant now = this.clock.instant();
        Optional<Instant> deadline = this.deadline();
        return new TimeBudget(this.clock, now, deadline.map(d -> Duration.between(now, d)));
    }

    public TimeBudget withDeadline(Instant deadline) {
        return new TimeBudget(this.clock, this.start, Optional.of(Duration.between(this.start, deadline)));
    }

    private static Duration nonNegativeBetween(Instant start, Instant end) {
        return TimeBudget.makeNonNegative(Duration.between(start, end));
    }

    private static Duration makeNonNegative(Duration duration) {
        return duration.isNegative() ? Duration.ZERO : duration;
    }
}

