/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;

public class Expand<NAMETYPE extends Name>
extends CompositeTensorFunction<NAMETYPE> {
    private final TensorFunction<NAMETYPE> argument;
    private final String dimensionName;

    public Expand(TensorFunction<NAMETYPE> argument, String dimension) {
        this.argument = argument;
        this.dimensionName = dimension;
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return Collections.singletonList(this.argument);
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Expand must have 1 argument, got " + arguments.size());
        }
        return new Expand<NAMETYPE>(arguments.get(0), this.dimensionName);
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        TensorType type = new TensorType.Builder(TensorType.Value.INT8).indexed(this.dimensionName, 1L).build();
        Generate expansion = new Generate(type, ScalarFunctions.constant(1.0));
        return new Join(expansion, this.argument, ScalarFunctions.multiply());
    }

    @Override
    public String toString(ToStringContext context) {
        return "expand(" + this.argument.toString(context) + ", " + this.dimensionName + ")";
    }
}

