/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import java.lang.reflect.Method;

public final class MethodCache {
    private final String methodName;
    private final CopyOnWriteHashMap<String, Method> cache = new CopyOnWriteHashMap();

    public MethodCache(String methodName) {
        this.methodName = methodName;
    }

    public final Method get(Object object) {
        Method m = this.cache.get(object.getClass().getName());
        if (m == null && (m = this.lookupMethod(object)) != null) {
            this.cache.put(object.getClass().getName(), m);
        }
        return m;
    }

    private Method lookupMethod(Object object) {
        try {
            return object.getClass().getMethod(this.methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

