/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.text.Utf8;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;

public final class JSONWriter {
    private Deque<Boolean> needsComma = new ArrayDeque<Boolean>();
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final OutputStream stream;

    public JSONWriter(OutputStream stream) {
        this.stream = stream;
    }

    private void beginFieldOrArrayValue() throws IOException {
        if (this.needsComma.getFirst().booleanValue()) {
            this.write(",");
        }
    }

    private void endFieldOrArrayValue() {
        this.setNeedsComma();
    }

    public JSONWriter beginField(String fieldName) throws IOException {
        this.beginFieldOrArrayValue();
        this.write("\"" + fieldName + "\":");
        return this;
    }

    public JSONWriter endField() throws IOException {
        this.endFieldOrArrayValue();
        return this;
    }

    public JSONWriter beginArrayValue() throws IOException {
        this.beginFieldOrArrayValue();
        return this;
    }

    public JSONWriter endArrayValue() throws IOException {
        this.endFieldOrArrayValue();
        return this;
    }

    public JSONWriter beginObject() throws IOException {
        this.write("{");
        this.needsComma.addFirst(Boolean.FALSE);
        return this;
    }

    public JSONWriter endObject() throws IOException {
        this.write("}");
        this.needsComma.removeFirst();
        return this;
    }

    public JSONWriter beginArray() throws IOException {
        this.write("[");
        this.needsComma.addFirst(Boolean.FALSE);
        return this;
    }

    public JSONWriter endArray() throws IOException {
        this.write("]");
        this.needsComma.removeFirst();
        return this;
    }

    public JSONWriter value(String value) throws IOException {
        this.write("\"").write(this.escape(value)).write("\"");
        return this;
    }

    public JSONWriter value(Number value) throws IOException {
        this.write(value.toString());
        return this;
    }

    public JSONWriter value(boolean value) throws IOException {
        this.write(Boolean.toString(value));
        return this;
    }

    public JSONWriter value() throws IOException {
        this.write("null");
        return this;
    }

    private void setNeedsComma() {
        if (this.level() == 0) {
            return;
        }
        this.needsComma.removeFirst();
        this.needsComma.addFirst(Boolean.TRUE);
    }

    private int level() {
        return this.needsComma.size();
    }

    private JSONWriter write(String string) throws IOException {
        if (string.length() == 0) {
            return this;
        }
        this.stream.write(Utf8.toBytes(string));
        return this;
    }

    private String escape(String in) {
        StringBuilder quoted = new StringBuilder((int)((double)in.length() * 1.2));
        return this.escape(in, quoted).toString();
    }

    private StringBuilder escape(String in, StringBuilder escaped) {
        block9: for (char c : in.toCharArray()) {
            switch (c) {
                case '\"': {
                    escaped.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    escaped.append("\\b");
                    continue block9;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block9;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block9;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block9;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        escaped.append("\\u").append(JSONWriter.fourDigitHexString(c));
                        continue block9;
                    }
                    escaped.append(c);
                }
            }
        }
        return escaped;
    }

    private static char[] fourDigitHexString(char c) {
        char[] hex = new char[4];
        int in = c & 0xFFFF;
        for (int i = 3; i >= 0; --i) {
            hex[i] = DIGITS[in & 0xF];
            in >>>= 4;
        }
        return hex;
    }
}

