/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ScalarFunctions {
    public static DoubleBinaryOperator add() {
        return new Add();
    }

    public static DoubleBinaryOperator divide() {
        return new Divide();
    }

    public static DoubleBinaryOperator equal() {
        return new Equal();
    }

    public static DoubleBinaryOperator greater() {
        return new Greater();
    }

    public static DoubleBinaryOperator less() {
        return new Less();
    }

    public static DoubleBinaryOperator max() {
        return new Max();
    }

    public static DoubleBinaryOperator min() {
        return new Min();
    }

    public static DoubleBinaryOperator mean() {
        return new Mean();
    }

    public static DoubleBinaryOperator multiply() {
        return new Multiply();
    }

    public static DoubleBinaryOperator pow() {
        return new Pow();
    }

    public static DoubleBinaryOperator squareddifference() {
        return new SquaredDifference();
    }

    public static DoubleBinaryOperator subtract() {
        return new Subtract();
    }

    public static DoubleBinaryOperator hamming() {
        return new Hamming();
    }

    public static DoubleUnaryOperator abs() {
        return new Abs();
    }

    public static DoubleUnaryOperator acos() {
        return new Acos();
    }

    public static DoubleUnaryOperator asin() {
        return new Asin();
    }

    public static DoubleUnaryOperator atan() {
        return new Atan();
    }

    public static DoubleUnaryOperator ceil() {
        return new Ceil();
    }

    public static DoubleUnaryOperator cos() {
        return new Cos();
    }

    public static DoubleUnaryOperator exp() {
        return new Exp();
    }

    public static DoubleUnaryOperator floor() {
        return new Floor();
    }

    public static DoubleUnaryOperator log() {
        return new Log();
    }

    public static DoubleUnaryOperator neg() {
        return new Neg();
    }

    public static DoubleUnaryOperator reciprocal() {
        return new Reciprocal();
    }

    public static DoubleUnaryOperator rsqrt() {
        return new Rsqrt();
    }

    public static DoubleUnaryOperator sin() {
        return new Sin();
    }

    public static DoubleUnaryOperator sigmoid() {
        return new Sigmoid();
    }

    public static DoubleUnaryOperator sqrt() {
        return new Sqrt();
    }

    public static DoubleUnaryOperator square() {
        return new Square();
    }

    public static DoubleUnaryOperator tan() {
        return new Tan();
    }

    public static DoubleUnaryOperator tanh() {
        return new Tanh();
    }

    public static DoubleUnaryOperator erf() {
        return new Erf();
    }

    public static DoubleUnaryOperator elu() {
        return new Elu();
    }

    public static DoubleUnaryOperator elu(double alpha) {
        return new Elu(alpha);
    }

    public static DoubleUnaryOperator leakyrelu() {
        return new LeakyRelu();
    }

    public static DoubleUnaryOperator leakyrelu(double alpha) {
        return new LeakyRelu(alpha);
    }

    public static DoubleUnaryOperator relu() {
        return new Relu();
    }

    public static DoubleUnaryOperator selu() {
        return new Selu();
    }

    public static DoubleUnaryOperator selu(double scale, double alpha) {
        return new Selu(scale, alpha);
    }

    public static Function<List<Long>, Double> random() {
        return new Random();
    }

    public static Function<List<Long>, Double> equal(List<String> argumentNames) {
        return new EqualElements(argumentNames);
    }

    public static Function<List<Long>, Double> sum(List<String> argumentNames) {
        return new SumElements(argumentNames);
    }

    public static Function<List<Long>, Double> constant(double value) {
        return new Constant(value);
    }

    public static class Constant
    implements Function<List<Long>, Double> {
        private final double value;

        public Constant(double value) {
            this.value = value;
        }

        @Override
        public Double apply(List<Long> values) {
            return this.value;
        }

        public String toString() {
            return Double.toString(this.value);
        }
    }

    public static class SumElements
    implements Function<List<Long>, Double> {
        private final ImmutableList<String> argumentNames;

        private SumElements(List<String> argumentNames) {
            this.argumentNames = ImmutableList.copyOf(argumentNames);
        }

        @Override
        public Double apply(List<Long> values) {
            long sum = 0L;
            for (Long value : values) {
                sum += value.longValue();
            }
            return sum;
        }

        public String toString() {
            return this.argumentNames.stream().collect(Collectors.joining("+"));
        }
    }

    public static class Random
    implements Function<List<Long>, Double> {
        @Override
        public Double apply(List<Long> values) {
            return ThreadLocalRandom.current().nextDouble();
        }

        public String toString() {
            return "random";
        }
    }

    public static class EqualElements
    implements Function<List<Long>, Double> {
        private final ImmutableList<String> argumentNames;

        private EqualElements(List<String> argumentNames) {
            this.argumentNames = ImmutableList.copyOf(argumentNames);
        }

        @Override
        public Double apply(List<Long> values) {
            if (values.isEmpty()) {
                return 1.0;
            }
            for (Long value : values) {
                if (value.equals(values.get(0))) continue;
                return 0.0;
            }
            return 1.0;
        }

        public String toString() {
            if (this.argumentNames.size() == 0) {
                return "1";
            }
            if (this.argumentNames.size() == 1) {
                return "1";
            }
            if (this.argumentNames.size() == 2) {
                return (String)this.argumentNames.get(0) + "==" + (String)this.argumentNames.get(1);
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.argumentNames.size() - 1; ++i) {
                b.append("(").append((String)this.argumentNames.get(i)).append("==").append((String)this.argumentNames.get(i + 1)).append(")");
                if (i >= this.argumentNames.size() - 2) continue;
                b.append("*");
            }
            return b.toString();
        }
    }

    public static class Erf
    implements DoubleUnaryOperator {
        static final Comparator<Double> byAbs = (x, y) -> Double.compare(Math.abs(x), Math.abs(y));
        static final double nearZeroMultiplier = 2.0 / Math.sqrt(Math.PI);

        static double kummer(double a, double b, double z) {
            PriorityQueue<Double> terms = new PriorityQueue<Double>(byAbs);
            double term = 1.0;
            long n = 0L;
            while (Math.abs(term) > Double.MIN_NORMAL) {
                terms.add(term);
                term *= a + (double)n;
                term /= b + (double)n;
                term *= z;
                term /= (double)(++n);
            }
            double sum = (Double)terms.remove();
            while (!terms.isEmpty()) {
                terms.add(sum += ((Double)terms.remove()).doubleValue());
                sum = (Double)terms.remove();
            }
            return sum;
        }

        static double approx_erfc(double x) {
            double sq = x * x;
            double mult = Math.exp(-sq) / (x * Math.sqrt(Math.PI));
            double term = 1.0;
            long n = 1L;
            double sum = 0.0;
            while (sum + term != sum) {
                double pterm = term;
                sum += term;
                term = 0.5 * pterm * (double)n / sq;
                if (term > pterm) {
                    return (sum -= 0.5 * pterm) * mult;
                }
                n += 2L;
                pterm = term;
                sum -= term;
                term = 0.5 * pterm * (double)n / sq;
                if (term > pterm) {
                    return (sum += 0.5 * pterm) * mult;
                }
                n += 2L;
            }
            return sum * mult;
        }

        @Override
        public double applyAsDouble(double operand) {
            return Erf.erf(operand);
        }

        public String toString() {
            return "f(a)(erf(a))";
        }

        public static double erf(double v) {
            if (v < 0.0) {
                return -Erf.erf(Math.abs(v));
            }
            if (v < 1.0E-10) {
                return v * nearZeroMultiplier;
            }
            if (v <= 1.0) {
                return v * nearZeroMultiplier * Erf.kummer(0.5, 1.5, -v * v);
            }
            if (v < 4.3) {
                return v * nearZeroMultiplier * Math.exp(-v * v) * Erf.kummer(1.0, 1.5, v * v);
            }
            return 1.0 - Erf.approx_erfc(v);
        }
    }

    public static class Tanh
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.tanh(operand);
        }

        public String toString() {
            return "f(a)(tanh(a))";
        }
    }

    public static class Tan
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.tan(operand);
        }

        public String toString() {
            return "f(a)(tan(a))";
        }
    }

    public static class Square
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return operand * operand;
        }

        public String toString() {
            return "f(a)(a * a)";
        }
    }

    public static class Sqrt
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.sqrt(operand);
        }

        public String toString() {
            return "f(a)(sqrt(a))";
        }
    }

    public static class Sigmoid
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / (1.0 + Math.exp(-operand));
        }

        public String toString() {
            return "f(a)(1 / (1 + exp(-a)))";
        }
    }

    public static class Rsqrt
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / Math.sqrt(operand);
        }

        public String toString() {
            return "f(a)(1.0 / sqrt(a))";
        }
    }

    public static class Sin
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.sin(operand);
        }

        public String toString() {
            return "f(a)(sin(a))";
        }
    }

    public static class LeakyRelu
    implements DoubleUnaryOperator {
        private final double alpha;

        public LeakyRelu() {
            this(0.01);
        }

        public LeakyRelu(double alpha) {
            this.alpha = alpha;
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.max(this.alpha * operand, operand);
        }

        public String toString() {
            return "f(a)(max(" + this.alpha + " * a, a))";
        }
    }

    public static class Selu
    implements DoubleUnaryOperator {
        private final double scale;
        private final double alpha;

        public Selu() {
            this(1.0507009873554805, 1.6732632423543772);
        }

        public Selu(double scale, double alpha) {
            this.scale = scale;
            this.alpha = alpha;
        }

        @Override
        public double applyAsDouble(double operand) {
            return this.scale * (operand >= 0.0 ? operand : this.alpha * (Math.exp(operand) - 1.0));
        }

        public String toString() {
            return "f(a)(" + this.scale + " * if(a >= 0, a, " + this.alpha + " * (exp(a) - 1)))";
        }
    }

    public static class Relu
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.max(operand, 0.0);
        }

        public String toString() {
            return "f(a)(max(0, a))";
        }
    }

    public static class Reciprocal
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return 1.0 / operand;
        }

        public String toString() {
            return "f(a)(1 / a)";
        }
    }

    public static class Neg
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return -operand;
        }

        public String toString() {
            return "f(a)(-a)";
        }
    }

    public static class Log
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.log(operand);
        }

        public String toString() {
            return "f(a)(log(a))";
        }
    }

    public static class Floor
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.floor(operand);
        }

        public String toString() {
            return "f(a)(floor(a))";
        }
    }

    public static class Exp
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.exp(operand);
        }

        public String toString() {
            return "f(a)(exp(a))";
        }
    }

    public static class Elu
    implements DoubleUnaryOperator {
        private final double alpha;

        public Elu() {
            this(1.0);
        }

        public Elu(double alpha) {
            this.alpha = alpha;
        }

        @Override
        public double applyAsDouble(double operand) {
            return operand < 0.0 ? this.alpha * (Math.exp(operand) - 1.0) : operand;
        }

        public String toString() {
            return "f(a)(if(a < 0, " + this.alpha + " * (exp(a)-1), a))";
        }
    }

    public static class Cos
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.cos(operand);
        }

        public String toString() {
            return "f(a)(cos(a))";
        }
    }

    public static class Ceil
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.ceil(operand);
        }

        public String toString() {
            return "f(a)(ceil(a))";
        }
    }

    public static class Atan
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.atan(operand);
        }

        public String toString() {
            return "f(a)(atan(a))";
        }
    }

    public static class Asin
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.asin(operand);
        }

        public String toString() {
            return "f(a)(asin(a))";
        }
    }

    public static class Acos
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.acos(operand);
        }

        public String toString() {
            return "f(a)(acos(a))";
        }
    }

    public static class Abs
    implements DoubleUnaryOperator {
        @Override
        public double applyAsDouble(double operand) {
            return Math.abs(operand);
        }

        public String toString() {
            return "f(a)(fabs(a))";
        }
    }

    public static class Hamming
    implements DoubleBinaryOperator {
        public static double hamming(double left, double right) {
            double distance = 0.0;
            byte a = (byte)left;
            byte b = (byte)right;
            for (int i = 0; i < 8; ++i) {
                byte bit = (byte)(1 << i);
                if ((a & bit) == (b & bit)) continue;
                distance += 1.0;
            }
            return distance;
        }

        @Override
        public double applyAsDouble(double left, double right) {
            return Hamming.hamming(left, right);
        }

        public String toString() {
            return "f(a,b)(hamming(a,b))";
        }
    }

    public static class Subtract
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left - right;
        }

        public String toString() {
            return "f(a,b)(a - b)";
        }
    }

    public static class SquaredDifference
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return (left - right) * (left - right);
        }

        public String toString() {
            return "f(a,b)((a-b) * (a-b))";
        }
    }

    public static class Divide
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left / right;
        }

        public String toString() {
            return "f(a,b)(a / b)";
        }
    }

    public static class Pow
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return Math.pow(left, right);
        }

        public String toString() {
            return "f(a,b)(pow(a, b))";
        }
    }

    public static class Multiply
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left * right;
        }

        public String toString() {
            return "f(a,b)(a * b)";
        }
    }

    public static class Mean
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return (left + right) / 2.0;
        }

        public String toString() {
            return "f(a,b)((a + b) / 2)";
        }
    }

    public static class Min
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return Math.min(left, right);
        }

        public String toString() {
            return "f(a,b)(min(a, b))";
        }
    }

    public static class Max
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return Math.max(left, right);
        }

        public String toString() {
            return "f(a,b)(max(a, b))";
        }
    }

    public static class Less
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left < right ? 1.0 : 0.0;
        }

        public String toString() {
            return "f(a,b)(a < b)";
        }
    }

    public static class Greater
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left > right ? 1.0 : 0.0;
        }

        public String toString() {
            return "f(a,b)(a > b)";
        }
    }

    public static class Equal
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left == right ? 1.0 : 0.0;
        }

        public String toString() {
            return "f(a,b)(a==b)";
        }
    }

    public static class Add
    implements DoubleBinaryOperator {
        @Override
        public double applyAsDouble(double left, double right) {
            return left + right;
        }

        public String toString() {
            return "f(a,b)(a + b)";
        }
    }
}

