/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.NixValue;
import com.yahoo.slime.ObjectValue;
import com.yahoo.slime.SymbolTable;
import com.yahoo.slime.Type;
import com.yahoo.slime.Value;
import com.yahoo.slime.Visitor;

final class ArrayValue
extends Value {
    private int capacity = 16;
    private int used = 0;
    private Value[] values = new Value[this.capacity];
    private final SymbolTable names;

    public ArrayValue(SymbolTable names) {
        this.names = names;
    }

    @Override
    public Type type() {
        return Type.ARRAY;
    }

    @Override
    public int children() {
        return this.used;
    }

    @Override
    public int entries() {
        return this.used;
    }

    @Override
    public Value entry(int index) {
        return index < this.used ? this.values[index] : NixValue.invalid();
    }

    @Override
    public void accept(Visitor v) {
        v.visitArray(this);
    }

    @Override
    public void traverse(ArrayTraverser at) {
        for (int i = 0; i < this.used; ++i) {
            at.entry(i, this.values[i]);
        }
    }

    private void grow() {
        Value[] v = this.values;
        this.capacity <<= 1;
        this.values = new Value[this.capacity];
        System.arraycopy(v, 0, this.values, 0, this.used);
    }

    @Override
    protected Value addLeaf(Value value) {
        if (this.used == this.capacity) {
            this.grow();
        }
        this.values[this.used++] = value;
        return value;
    }

    @Override
    public Value addArray() {
        return this.addLeaf(new ArrayValue(this.names));
    }

    @Override
    public Value addObject() {
        return this.addLeaf(new ObjectValue(this.names));
    }
}

