/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.io;

import com.yahoo.io.BufferChain;
import com.yahoo.io.WritableByteTransmitter;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.GenericWriter;
import com.yahoo.text.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public abstract class AbstractByteWriter
extends GenericWriter
implements WritableByteTransmitter {
    protected final CharsetEncoder encoder;
    protected final BufferChain buffer;
    protected final CharBuffer charBuffer = CharBuffer.allocate(2);

    protected AbstractByteWriter(CharsetEncoder encoder) {
        this.encoder = encoder;
        this.buffer = new BufferChain(this);
    }

    public Charset getEncoding() {
        return this.encoder.charset();
    }

    @Override
    public GenericWriter write(AbstractUtf8Array v) throws IOException {
        this.buffer.append(v);
        return this;
    }

    @Override
    public GenericWriter write(long v) throws IOException {
        this.buffer.append(Utf8.toAsciiBytes(v));
        return this;
    }

    @Override
    public void write(int v) throws IOException {
        char c = (char)v;
        if (Character.isSurrogate(c)) {
            this.charBuffer.append(c);
            if (!this.charBuffer.hasRemaining()) {
                this.charBuffer.flip();
                this.buffer.append(this.charBuffer, this.encoder);
                this.charBuffer.clear();
            }
        } else {
            this.charBuffer.clear();
            this.charBuffer.append((char)v);
            this.charBuffer.flip();
            this.buffer.append(this.charBuffer, this.encoder);
            this.charBuffer.clear();
        }
    }

    @Override
    public GenericWriter write(double v) throws IOException {
        this.buffer.append(Utf8.toBytes(String.valueOf(v)));
        return this;
    }

    @Override
    public GenericWriter write(float v) throws IOException {
        this.buffer.append(Utf8.toBytes(String.valueOf(v)));
        return this;
    }

    @Override
    public GenericWriter write(short v) throws IOException {
        this.buffer.append(Utf8.toAsciiBytes(v));
        return this;
    }

    @Override
    public GenericWriter write(boolean v) throws IOException {
        this.buffer.append(Utf8.toAsciiBytes(v));
        return this;
    }

    @Override
    public void write(char[] cbuf, int offset, int len) throws IOException {
        CharBuffer in = CharBuffer.wrap(cbuf, offset, len);
        this.buffer.append(in, this.encoder);
    }

    public void append(ByteBuffer alreadyEncoded) throws IOException {
        this.buffer.append(alreadyEncoded);
    }

    public void append(byte alreadyEncoded) throws IOException {
        this.buffer.append(alreadyEncoded);
    }

    public void append(byte[] alreadyEncoded) throws IOException {
        this.buffer.append(alreadyEncoded);
    }

    public void append(byte[] alreadyEncoded, int offset, int length) throws IOException {
        this.buffer.append(alreadyEncoded, offset, length);
    }

    public long appended() {
        return this.buffer.appended();
    }
}

