/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.geo;

import com.yahoo.geo.OneDegreeParser;

public class ParsedDegree {
    public final double degrees;
    public final boolean isLatitude;
    public final boolean isLongitude;

    public ParsedDegree(double value, boolean isLat, boolean isLon) {
        this.degrees = value;
        this.isLatitude = isLat;
        this.isLongitude = isLon;
        if (isLat && isLon) {
            throw new IllegalArgumentException("value cannot be both latitude and longitude at once");
        }
        if (isLat || isLon) {
            return;
        }
        throw new IllegalArgumentException("value must be either latitude or longitude");
    }

    public static ParsedDegree fromString(String toParse, boolean assumeLatitude, boolean assumeLongitude) {
        if (assumeLatitude && assumeLongitude) {
            throw new IllegalArgumentException("value cannot be both latitude and longitude at once");
        }
        OneDegreeParser parser = new OneDegreeParser(assumeLatitude, toParse);
        if (parser.foundLatitude) {
            return new ParsedDegree(parser.latitude, true, false);
        }
        if (parser.foundLongitude) {
            return new ParsedDegree(parser.longitude, false, true);
        }
        throw new IllegalArgumentException("could not parse: " + toParse);
    }

    public String toString() {
        if (this.isLatitude) {
            return "Latitude: " + this.degrees + " degrees";
        }
        return "Longitude: " + this.degrees + " degrees";
    }
}

