/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ThreadRobustList<T>
implements Iterable<T> {
    private Object[] items;
    private int next = 0;

    public ThreadRobustList() {
        this(10);
    }

    public ThreadRobustList(int initialCapacity) {
        this.items = new Object[initialCapacity];
    }

    public void add(T item) {
        Object[] workItems = this.items;
        if (this.next >= this.items.length) {
            int newLength = 20 + this.items.length * 2;
            workItems = Arrays.copyOf(workItems, newLength);
            workItems[this.next++] = item;
            this.items = workItems;
        } else {
            workItems[this.next++] = item;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ThreadRobustIterator(this.items);
    }

    public Iterator<T> reverseIterator() {
        return new ThreadRobustReverseIterator(this.items);
    }

    public boolean isEmpty() {
        return this.next == 0;
    }

    private class ThreadRobustReverseIterator
    implements Iterator<T> {
        private final Object[] items;
        private int nextIndex;

        public ThreadRobustReverseIterator(Object[] items) {
            this.items = items;
            this.nextIndex = this.findLastAssignedIndex(items);
        }

        private int findLastAssignedIndex(Object[] items) {
            for (int i = items.length - 1; i >= 0; --i) {
                if (items[i] == null) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported on thread robust list iterators");
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            return this.items[this.nextIndex--];
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }
    }

    private class ThreadRobustIterator
    implements Iterator<T> {
        private final Object[] items;
        private int nextIndex = 0;

        public ThreadRobustIterator(Object[] items) {
            this.items = items;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported on thread robust list iterators");
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            return this.items[this.nextIndex++];
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex >= this.items.length) {
                return false;
            }
            return this.items[this.nextIndex] != null;
        }
    }
}

