/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CompletableFutures {
    private CompletableFutures() {
    }

    public static <T> CompletableFuture<T> firstOf(List<CompletableFuture<T>> futures) {
        int size = futures.size();
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        if (size == 1) {
            return futures.get(0);
        }
        class Combiner {
            final Object monitor = new Object();
            final CompletableFuture<T> combined = new CompletableFuture();
            final int futuresCount;
            Throwable error = null;
            int exceptionCount = 0;

            Combiner(int futuresCount) {
                this.futuresCount = futuresCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void onCompletion(T value, Throwable error) {
                if (this.combined.isDone()) {
                    return;
                }
                Object valueToComplete = null;
                Throwable exceptionToComplete = null;
                Object object = this.monitor;
                synchronized (object) {
                    if (value != null) {
                        valueToComplete = value;
                    } else {
                        if (this.error == null) {
                            this.error = error;
                        } else {
                            this.error.addSuppressed(error);
                        }
                        if (++this.exceptionCount == this.futuresCount) {
                            exceptionToComplete = this.error;
                        }
                    }
                }
                if (valueToComplete != null) {
                    this.combined.complete(value);
                } else if (exceptionToComplete != null) {
                    this.combined.completeExceptionally(exceptionToComplete);
                }
            }
        }
        Combiner combiner = new Combiner(size);
        futures.forEach(future -> future.whenComplete(combiner::onCompletion));
        return combiner.combined;
    }
}

