/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CollectionUtil {
    public static String mkString(Collection<?> collection, String sep) {
        return CollectionUtil.mkString(collection, "", sep, "");
    }

    public static <T> String mkString(Collection<T> collection, String start, String sep, String end) {
        return collection.stream().map(Object::toString).collect(Collectors.joining(sep, start, end));
    }

    public static boolean equalContentsIgnoreOrder(Collection<?> c1, Collection<?> c2) {
        return c1.size() == c2.size() && c1.containsAll(c2);
    }

    public static <T> Set<T> symmetricDifference(Collection<? extends T> c1, Collection<? extends T> c2) {
        HashSet<T> diff1 = new HashSet<T>(c1);
        diff1.removeAll(c2);
        HashSet<T> diff2 = new HashSet<T>(c2);
        diff2.removeAll(c1);
        diff1.addAll(diff2);
        return diff1;
    }

    public static <T> Collection<T> filter(Collection<?> collection, Class<T> lowerBound) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object element : collection) {
            if (!lowerBound.isInstance(element)) continue;
            result.add(lowerBound.cast(element));
        }
        return result;
    }

    public static <T> T first(Collection<T> collection) {
        return collection.isEmpty() ? null : (T)collection.iterator().next();
    }

    public static <T> Optional<T> firstMatching(T[] array, Predicate<? super T> predicate) {
        for (T t : array) {
            if (!predicate.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }
}

