/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.ForwardWriter;
import com.yahoo.text.GenericWriter;
import com.yahoo.text.JavaWriterWriter;
import com.yahoo.text.Utf8String;
import com.yahoo.text.XML;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XMLWriter
extends ForwardWriter {
    private final int maxIndentLevel;
    private final int maxLineSeparatorLevel;
    private final List<Utf8String> openTags = new ArrayList<Utf8String>();
    private final List<Utf8String> unmodifiableOpenTags = Collections.unmodifiableList(this.openTags);
    private boolean inOpenStartTag;
    private boolean currentIsMultiline;
    private boolean isFirstInParent;
    private final boolean markupIsAscii;
    private static final Utf8String SPACE = new Utf8String(" ");
    private static final Utf8String INDENT = new Utf8String("  ");
    private static final Utf8String ATTRIBUTE_START = new Utf8String("=\"");
    private static final Utf8String ATTRIBUTE_END = new Utf8String("\"");
    private static final Utf8String ENCODING_START = new Utf8String("<?xml version=\"1.0\" encoding=\"");
    private static final Utf8String ENCODING_END = new Utf8String("\" ?>\n");
    private static final Utf8String LF = new Utf8String("\n");
    private static final Utf8String LT = new Utf8String("<");
    private static final Utf8String GT = new Utf8String(">");
    private static final Utf8String ELT = new Utf8String("</");
    private static final Utf8String EGT = new Utf8String("/>");

    public XMLWriter(Writer writer) {
        this(writer, 10);
    }

    public XMLWriter(Writer writer, boolean markupIsAscii) {
        this(writer, 10, markupIsAscii);
    }

    public XMLWriter(Writer writer, int maxIndentLevel) {
        this(writer, maxIndentLevel, 1);
    }

    public XMLWriter(Writer writer, int maxIndentLevel, boolean markupIsAscii) {
        this(writer, maxIndentLevel, 1, markupIsAscii);
    }

    public XMLWriter(Writer writer, int maxIndentLevel, int maxLineSeparatorLevel) {
        this(writer, maxIndentLevel, maxLineSeparatorLevel, true);
    }

    public XMLWriter(Writer writer, int maxIndentLevel, int maxLineSeparatorLevel, boolean markupIsAscii) {
        super(writer instanceof GenericWriter ? (GenericWriter)writer : new JavaWriterWriter(writer));
        this.maxIndentLevel = maxIndentLevel;
        this.maxLineSeparatorLevel = maxLineSeparatorLevel;
        this.markupIsAscii = markupIsAscii;
    }

    public static XMLWriter from(Writer writer, int maxIndentLevel, int maxLineSeparatorLevel) {
        return writer instanceof XMLWriter ? (XMLWriter)writer : new XMLWriter(writer, maxIndentLevel, maxLineSeparatorLevel);
    }

    public static XMLWriter from(Writer writer) {
        return writer instanceof XMLWriter ? (XMLWriter)writer : new XMLWriter(writer);
    }

    public Writer getWrapped() {
        return this.getWriter() instanceof JavaWriterWriter ? ((JavaWriterWriter)this.getWriter()).getWriter() : this.getWriter();
    }

    public void xmlHeader(String encoding) {
        this.w(ENCODING_START).w(encoding).w(ENCODING_END);
    }

    public XMLWriter openTag(String s) {
        return this.openTag(new Utf8String(s));
    }

    public XMLWriter openTag(Utf8String tag) {
        this.closeStartTag();
        if (this.openTags.size() > 0) {
            this.w(LF);
            if (this.isFirstInParent && this.openTags.size() <= this.maxLineSeparatorLevel) {
                this.w(LF);
            }
            this.indent();
        }
        this.w(LT).w(tag);
        this.openTags.add(tag);
        this.inOpenStartTag = true;
        this.currentIsMultiline = false;
        this.isFirstInParent = true;
        return this;
    }

    public XMLWriter closeTag() {
        if (this.openTags.size() <= 0) {
            throw new RuntimeException("Called closeTag() when no tag was open");
        }
        Utf8String lastOpenTag = this.openTags.remove(this.openTags.size() - 1);
        if (this.inOpenStartTag) {
            this.w(EGT);
        } else {
            if (this.currentIsMultiline) {
                this.w(LF).indent();
            }
            this.w(ELT).w(lastOpenTag).w(GT);
        }
        if (this.openTags.size() == 0 || this.openTags.size() <= this.maxLineSeparatorLevel) {
            this.w(LF);
        }
        this.inOpenStartTag = false;
        this.currentIsMultiline = true;
        this.isFirstInParent = false;
        return this;
    }

    private XMLWriter indent() {
        for (int i = 0; i < this.openTags.size() && i < this.maxIndentLevel; ++i) {
            this.w(INDENT);
        }
        return this;
    }

    public XMLWriter closeStartTag() {
        if (!this.inOpenStartTag) {
            return this;
        }
        this.w(GT);
        this.inOpenStartTag = false;
        return this;
    }

    public XMLWriter forceAttribute(Utf8String name, Object value) {
        String stringValue = value != null ? value.toString() : "";
        this.allowAttribute();
        return this.w(SPACE).w(name).w(ATTRIBUTE_START).wTranscode(XML.xmlEscape(stringValue, true)).w(ATTRIBUTE_END);
    }

    public XMLWriter forceAttribute(String name, Object value) {
        return this.forceAttribute(new Utf8String(name), value);
    }

    private void allowAttribute() {
        if (!this.inOpenStartTag) {
            throw new RuntimeException("Called writeAttribute() while not in an open start tag");
        }
    }

    public XMLWriter attribute(Utf8String name, AbstractUtf8Array value) {
        if (value.isEmpty()) {
            return this;
        }
        this.allowAttribute();
        return this.w(SPACE).w(name).w(ATTRIBUTE_START).w(value).w(ATTRIBUTE_END);
    }

    public XMLWriter attribute(Utf8String name, Number value) {
        if (value == null) {
            return this;
        }
        this.allowAttribute();
        return this.w(SPACE).w(name).w(ATTRIBUTE_START).w(value).w(ATTRIBUTE_END);
    }

    public XMLWriter attribute(Utf8String name, long value) {
        this.allowAttribute();
        return this.w(SPACE).w(name).w(ATTRIBUTE_START).w(value).w(ATTRIBUTE_END);
    }

    public XMLWriter attribute(Utf8String name, double value) {
        this.allowAttribute();
        return this.w(SPACE).w(name).w(ATTRIBUTE_START).w(value).w(ATTRIBUTE_END);
    }

    public XMLWriter attribute(Utf8String name, boolean value) {
        this.allowAttribute();
        return this.w(SPACE).w(name).w(ATTRIBUTE_START).w(value).w(ATTRIBUTE_END);
    }

    public XMLWriter attribute(Utf8String name, String value) {
        if (value == null || value.isEmpty()) {
            return this;
        }
        this.allowAttribute();
        return this.w(SPACE).w(name).w(ATTRIBUTE_START).wTranscode(XML.xmlEscape(value, true)).w(ATTRIBUTE_END);
    }

    public XMLWriter attribute(String name, Object value) {
        if (value == null) {
            return this;
        }
        return this.attribute(new Utf8String(name), value.toString());
    }

    public XMLWriter content(Object content, boolean multiline) {
        this.closeStartTag();
        return content == null ? this : this.escapedContent(XML.xmlEscape(content.toString(), false), multiline);
    }

    public XMLWriter escapedContent(String content, boolean multiline) {
        this.closeStartTag();
        if (content == null) {
            return this;
        }
        if (multiline) {
            this.currentIsMultiline = true;
        }
        return this.wTranscode(content);
    }

    public XMLWriter escapedAsciiContent(String content, boolean multiline) {
        this.closeStartTag();
        if (content == null) {
            return this;
        }
        if (multiline) {
            this.currentIsMultiline = true;
        }
        return this.w(content);
    }

    private final XMLWriter w(String s) {
        return this.markupIsAscii ? this.w(new Utf8String(s)) : this.w(s);
    }

    private final XMLWriter w(AbstractUtf8Array utf8) {
        this.write(utf8);
        return this;
    }

    private final XMLWriter w(long v) {
        this.write(v);
        return this;
    }

    private final XMLWriter w(boolean v) {
        this.write(v);
        return this;
    }

    private final XMLWriter w(double v) {
        this.write(v);
        return this;
    }

    private final XMLWriter w(Number v) {
        this.write(v.toString());
        return this;
    }

    private final XMLWriter wTranscode(String s) {
        this.write(s);
        return this;
    }

    public List<Utf8String> openTags() {
        return this.unmodifiableOpenTags;
    }

    public boolean isIn(Utf8String containingTag) {
        return this.openTags.size() != 0 && this.openTags.get(this.openTags.size() - 1).equals(containingTag);
    }

    public boolean isIn(String containingTag) {
        return this.openTags.size() != 0 && this.openTags.get(this.openTags.size() - 1).equals(containingTag);
    }
}

