/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayInserter;
import com.yahoo.slime.BufferedInput;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inserter;
import com.yahoo.slime.JsonParseException;
import com.yahoo.slime.ObjectInserter;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeInserter;
import com.yahoo.text.Text;
import com.yahoo.text.Utf8;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class JsonDecoder {
    private BufferedInput in;
    private byte c;
    private final SlimeInserter slimeInserter = new SlimeInserter(null);
    private final ArrayInserter arrayInserter = new ArrayInserter(null);
    private final ObjectInserter objectInserter = new ObjectInserter(null, null);
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private static final byte[] SQUARE_BRACKET_OPEN = new byte[]{91};
    private static final byte[] SQUARE_BRACKET_CLOSE = new byte[]{93};
    private static final byte[] CURLY_BRACE_OPEN = new byte[]{123};
    private static final byte[] CURLY_BRACE_CLOSE = new byte[]{125};
    private static final byte[] COLON = new byte[]{58};
    private static final byte COMMA = 44;
    private static byte[] unicodeStart = new byte[]{92, 117};

    public Slime decode(Slime slime, byte[] bytes) {
        return this.decode(slime, ByteBuffer.wrap(bytes));
    }

    public Slime decode(Slime slime, ByteBuffer buf) {
        this.in = new BufferedInput(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        this.next();
        this.decodeValue(this.slimeInserter.adjust(slime));
        if (this.in.failed()) {
            slime.wrap("partial_result");
            slime.get().setData("offending_input", this.in.getOffending());
            slime.get().setString("error_message", this.in.getErrorMessage());
        }
        return slime;
    }

    public Slime decodeOrThrow(Slime slime, byte[] bytes) {
        this.in = new BufferedInput(bytes);
        this.next();
        this.decodeValue(this.slimeInserter.adjust(slime));
        if (this.in.failed()) {
            throw new JsonParseException(this.in);
        }
        return slime;
    }

    private void decodeValue(Inserter inserter) {
        this.skipWhiteSpace();
        switch (this.c) {
            case 34: 
            case 39: {
                this.decodeString(inserter);
                return;
            }
            case 123: {
                this.decodeObject(inserter);
                return;
            }
            case 91: {
                this.decodeArray(inserter);
                return;
            }
            case 116: {
                this.expect(TRUE);
                inserter.insertBOOL(true);
                return;
            }
            case 102: {
                this.expect(FALSE);
                inserter.insertBOOL(false);
                return;
            }
            case 110: {
                this.expect(NULL);
                inserter.insertNIX();
                return;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.decodeNumber(inserter);
                return;
            }
        }
        this.in.fail("Expected start of value but got " + this.characterToReadableString(this.c));
    }

    private void decodeNumber(Inserter inserter) {
        this.buf.reset();
        boolean likelyFloatingPoint = false;
        block4: while (true) {
            switch (this.c) {
                case 46: 
                case 69: 
                case 101: {
                    likelyFloatingPoint = true;
                }
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.buf.write(this.c);
                    this.next();
                    continue block4;
                }
            }
            break;
        }
        if (likelyFloatingPoint) {
            double num = Double.parseDouble(Utf8.toString(this.buf.toByteArray()));
            inserter.insertDOUBLE(num);
        } else {
            long num = Long.parseLong(Utf8.toString(this.buf.toByteArray()));
            inserter.insertLONG(num);
        }
    }

    private void expect(byte[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            if (this.skip(expected[i])) continue;
            this.in.fail("Unexpected " + this.characterToReadableString(this.c));
            return;
        }
    }

    private void decodeArray(Inserter inserter) {
        Cursor cursor = inserter.insertARRAY();
        this.expect(SQUARE_BRACKET_OPEN);
        this.skipWhiteSpace();
        if (this.c != 93) {
            do {
                this.arrayInserter.adjust(cursor);
                this.decodeValue(this.arrayInserter);
                this.skipWhiteSpace();
            } while (this.skip((byte)44));
        }
        this.expect(SQUARE_BRACKET_CLOSE);
    }

    private void decodeObject(Inserter inserter) {
        Cursor cursor = inserter.insertOBJECT();
        this.expect(CURLY_BRACE_OPEN);
        this.skipWhiteSpace();
        if (this.c != 125) {
            do {
                this.skipWhiteSpace();
                String key = this.readKey();
                this.skipWhiteSpace();
                this.expect(COLON);
                this.objectInserter.adjust(cursor, key);
                this.decodeValue(this.objectInserter);
                this.skipWhiteSpace();
            } while (this.skip((byte)44));
        }
        this.expect(CURLY_BRACE_CLOSE);
    }

    private String readKey() {
        this.buf.reset();
        switch (this.c) {
            case 34: 
            case 39: {
                return this.readString();
            }
        }
        while (true) {
            switch (this.c) {
                case 0: 
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 58: {
                    return Utf8.toString(this.buf.toByteArray());
                }
            }
            this.buf.write(this.c);
            this.next();
        }
    }

    private void decodeString(Inserter inserter) {
        String value = this.readString();
        inserter.insertSTRING(value);
    }

    private String readString() {
        this.buf.reset();
        byte quote = this.c;
        assert (quote == 34 || quote == 39);
        this.next();
        block14: while (true) {
            switch (this.c) {
                case 92: {
                    this.next();
                    switch (this.c) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            this.buf.write(this.c);
                            break;
                        }
                        case 98: {
                            this.buf.write(8);
                            break;
                        }
                        case 102: {
                            this.buf.write(12);
                            break;
                        }
                        case 110: {
                            this.buf.write(10);
                            break;
                        }
                        case 114: {
                            this.buf.write(13);
                            break;
                        }
                        case 116: {
                            this.buf.write(9);
                            break;
                        }
                        case 117: {
                            JsonDecoder.writeUtf8(this.dequoteUtf16(), this.buf, -128L);
                            continue block14;
                        }
                        default: {
                            this.in.fail("Invalid quoted char(" + this.c + ")");
                        }
                    }
                    this.next();
                    continue block14;
                }
                case 34: 
                case 39: {
                    if (this.c == quote) {
                        this.next();
                        return Utf8.toString(this.buf.toByteArray());
                    }
                    this.buf.write(this.c);
                    this.next();
                    continue block14;
                }
                case 0: {
                    this.in.fail("Unterminated string");
                    return Utf8.toString(this.buf.toByteArray());
                }
            }
            this.buf.write(this.c);
            this.next();
        }
    }

    private static void writeUtf8(long codepoint, ByteArrayOutputStream buf, long mask) {
        if ((codepoint & mask) == 0L) {
            buf.write((byte)(mask << 1 | codepoint));
        } else {
            JsonDecoder.writeUtf8(codepoint >> 6, buf, mask >> (int)(2L - (mask >> 6 & 1L)));
            buf.write((byte)(0x80L | codepoint & 0x3FL));
        }
    }

    private long dequoteUtf16() {
        this.next();
        long codepoint = this.readHexValue(4);
        if (codepoint >= 55296L) {
            if (codepoint < 56320L) {
                this.expect(unicodeStart);
                long low = this.readHexValue(4);
                if (low >= 56320L && low < 57344L) {
                    codepoint = 65536L + (codepoint - 55296L << 10) + (low - 56320L);
                } else {
                    this.in.fail("Missing low surrogate");
                }
            } else if (codepoint < 57344L) {
                this.in.fail("Unexpected low surrogate");
            }
        }
        return codepoint;
    }

    private long readHexValue(int numBytes) {
        long ret = 0L;
        for (long i = 0L; i < (long)numBytes; ++i) {
            switch (this.c) {
                case 48: {
                    ret <<= 4;
                    break;
                }
                case 49: {
                    ret = ret << 4 | 1L;
                    break;
                }
                case 50: {
                    ret = ret << 4 | 2L;
                    break;
                }
                case 51: {
                    ret = ret << 4 | 3L;
                    break;
                }
                case 52: {
                    ret = ret << 4 | 4L;
                    break;
                }
                case 53: {
                    ret = ret << 4 | 5L;
                    break;
                }
                case 54: {
                    ret = ret << 4 | 6L;
                    break;
                }
                case 55: {
                    ret = ret << 4 | 7L;
                    break;
                }
                case 56: {
                    ret = ret << 4 | 8L;
                    break;
                }
                case 57: {
                    ret = ret << 4 | 9L;
                    break;
                }
                case 65: 
                case 97: {
                    ret = ret << 4 | 0xAL;
                    break;
                }
                case 66: 
                case 98: {
                    ret = ret << 4 | 0xBL;
                    break;
                }
                case 67: 
                case 99: {
                    ret = ret << 4 | 0xCL;
                    break;
                }
                case 68: 
                case 100: {
                    ret = ret << 4 | 0xDL;
                    break;
                }
                case 69: 
                case 101: {
                    ret = ret << 4 | 0xEL;
                    break;
                }
                case 70: 
                case 102: {
                    ret = ret << 4 | 0xFL;
                    break;
                }
                default: {
                    this.in.fail("Invalid hex character");
                    return 0L;
                }
            }
            this.next();
        }
        return ret;
    }

    private void next() {
        this.c = !this.in.eof() ? this.in.getByte() : (byte)0;
    }

    private boolean skip(byte x) {
        if (this.c != x) {
            return false;
        }
        this.next();
        return true;
    }

    private void skipWhiteSpace() {
        block3: while (true) {
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.next();
                    continue block3;
                }
            }
            break;
        }
    }

    private String characterToReadableString(int codePoint) {
        if (codePoint == 0) {
            return "end of data";
        }
        if (Text.isDisplayable(codePoint)) {
            return "character '" + String.valueOf(Character.toChars(this.c)) + "'";
        }
        return "character code " + this.c;
    }
}

