/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.geo;

public class DegreesParser {
    public double latitude = 0.0;
    public double longitude = 0.0;
    private String parseString = null;
    private int len = 0;
    private int pos = 0;

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private boolean isCompassDirection(char ch) {
        return ch == 'N' || ch == 'S' || ch == 'E' || ch == 'W';
    }

    private char getNextChar() throws IllegalArgumentException {
        if (this.pos == this.len) {
            ++this.pos;
            return '\u0000';
        }
        if (this.pos > this.len) {
            throw new IllegalArgumentException("position after end of string");
        }
        return this.parseString.charAt(this.pos++);
    }

    public DegreesParser(String latandlong) throws IllegalArgumentException {
        this.parseString = latandlong;
        this.len = this.parseString.length();
        char ch = this.getNextChar();
        boolean latSet = false;
        boolean longSet = false;
        double degrees = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        boolean degSet = false;
        boolean minSet = false;
        boolean secSet = false;
        boolean dirSet = false;
        boolean foundDot = false;
        boolean foundDigits = false;
        boolean findingLatitude = false;
        boolean findingLongitude = false;
        double sign = 0.0;
        int lastpos = -1;
        do {
            boolean valid = false;
            if (this.pos == lastpos) {
                throw new RuntimeException("internal logic error at '" + this.parseString + "' pos:" + this.pos);
            }
            lastpos = this.pos;
            double accum = 0.0;
            if (this.isDigit(ch) || ch == '.') {
                valid = true;
                if (foundDigits) {
                    throw new IllegalArgumentException("found digits after not consuming previous digits");
                }
                double divider = 1.0;
                foundDot = false;
                while (this.isDigit(ch)) {
                    foundDigits = true;
                    accum *= 10.0;
                    accum += (double)(ch - 48);
                    ch = this.getNextChar();
                }
                if (ch == '.') {
                    foundDot = true;
                    ch = this.getNextChar();
                    while (this.isDigit(ch)) {
                        foundDigits = true;
                        accum *= 10.0;
                        accum += (double)(ch - 48);
                        divider *= 10.0;
                        ch = this.getNextChar();
                    }
                }
                if (!foundDigits) {
                    throw new IllegalArgumentException("just a . is not a valid number");
                }
                accum /= divider;
            }
            if (ch == '\u00b0' || ch == 'o') {
                valid = true;
                if (degSet) {
                    throw new IllegalArgumentException("degrees sign only valid just after degrees");
                }
                if (!foundDigits) {
                    throw new IllegalArgumentException("must have number before degrees sign");
                }
                if (foundDot) {
                    throw new IllegalArgumentException("cannot have fractional degrees before degrees sign");
                }
                ch = this.getNextChar();
            }
            if (ch == '\'') {
                if (minSet || !degSet || !foundDigits) {
                    throw new IllegalArgumentException("minutes sign only valid just after minutes");
                }
                if (foundDot) {
                    throw new IllegalArgumentException("cannot have fractional minutes before minutes sign");
                }
                ch = this.getNextChar();
            }
            if (foundDigits) {
                valid = true;
                if (degSet) {
                    if (minSet) {
                        if (secSet) {
                            throw new IllegalArgumentException("extra number after full field");
                        }
                        seconds = accum;
                        secSet = true;
                    } else {
                        minutes = accum;
                        minSet = true;
                        if (foundDot) {
                            secSet = true;
                        }
                    }
                } else {
                    degrees = accum;
                    degSet = true;
                    if (foundDot) {
                        minSet = true;
                        secSet = true;
                    }
                }
                foundDot = false;
                foundDigits = false;
            }
            if (this.isCompassDirection(ch)) {
                valid = true;
                if (dirSet) {
                    throw new IllegalArgumentException("already set direction once, cannot add direction: " + ch);
                }
                dirSet = true;
                sign = ch == 'S' || ch == 'W' ? -1.0 : 1.0;
                if (ch == 'E' || ch == 'W') {
                    findingLongitude = true;
                } else {
                    findingLatitude = true;
                }
                ch = this.getNextChar();
            }
            if (ch == '\u0000' || ch == ';' || ch == ' ') {
                valid = true;
                if (!dirSet) {
                    throw new IllegalArgumentException("end of field without any compass direction seen");
                }
                if (!degSet) {
                    throw new IllegalArgumentException("end of field without any number seen");
                }
                degrees += minutes / 60.0;
                degrees += seconds / 3600.0;
                degrees *= sign;
                if (findingLatitude) {
                    if (latSet) {
                        throw new IllegalArgumentException("found latitude (N or S) twice");
                    }
                    if (degrees < -90.0 || degrees > 90.0) {
                        throw new IllegalArgumentException("out of range [-90,+90]: " + degrees);
                    }
                    this.latitude = degrees;
                    latSet = true;
                } else if (findingLongitude) {
                    if (longSet) {
                        throw new IllegalArgumentException("found longitude (E or W) twice");
                    }
                    if (degrees < -180.0 || degrees > 180.0) {
                        throw new IllegalArgumentException("out of range [-180,+180]: " + degrees);
                    }
                    this.longitude = degrees;
                    longSet = true;
                } else {
                    throw new IllegalArgumentException("no direction found");
                }
                degrees = 0.0;
                minutes = 0.0;
                seconds = 0.0;
                degSet = false;
                minSet = false;
                secSet = false;
                dirSet = false;
                foundDot = false;
                foundDigits = false;
                findingLatitude = false;
                findingLongitude = false;
                sign = 0.0;
                if (ch == '\u0000') break;
                ch = this.getNextChar();
            }
            if (valid) continue;
            throw new IllegalArgumentException("invalid character: " + ch);
        } while (ch != '\u0000');
        if (!latSet) {
            throw new IllegalArgumentException("missing latitude");
        }
        if (!longSet) {
            throw new IllegalArgumentException("missing longitude");
        }
    }
}

