/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import com.yahoo.concurrent.ThreadFactoryFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CachedThreadPoolWithFallback
implements AutoCloseable,
Executor {
    private final ExecutorService primary;
    private final ExecutorService secondary;

    public CachedThreadPoolWithFallback(String baseName, int corePoolSize, int maximumPoolSize, long keepAlimeTime, TimeUnit timeUnit) {
        this.primary = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAlimeTime, timeUnit, new SynchronousQueue<Runnable>(), ThreadFactoryFactory.getDaemonThreadFactory(baseName + ".primary"));
        this.secondary = Executors.newSingleThreadExecutor(ThreadFactoryFactory.getDaemonThreadFactory(baseName + ".secondary"));
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.primary.execute(command);
        }
        catch (RejectedExecutionException e1) {
            this.secondary.execute(() -> this.retryForever(command));
        }
    }

    private void retryForever(Runnable command) {
        while (true) {
            try {
                this.primary.execute(command);
                return;
            }
            catch (RejectedExecutionException rejected) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        this.secondary.shutdown();
        CachedThreadPoolWithFallback.join(this.secondary);
        this.primary.shutdown();
        CachedThreadPoolWithFallback.join(this.primary);
    }

    private static void join(ExecutorService executor) {
        while (true) {
            try {
                while (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

