/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MixedTensor
implements Tensor {
    private final TensorType type;
    private final ImmutableList<Tensor.Cell> cells;
    private final Index index;

    private MixedTensor(TensorType type, ImmutableList<Tensor.Cell> cells, Index index) {
        this.type = type;
        this.cells = ImmutableList.copyOf(cells);
        this.index = index;
    }

    @Override
    public TensorType type() {
        return this.type;
    }

    @Override
    public long size() {
        return this.cells.size();
    }

    @Override
    public double get(TensorAddress address) {
        long cellIndex = this.index.indexOf(address);
        if (cellIndex < 0L) {
            return Double.NaN;
        }
        Tensor.Cell cell = (Tensor.Cell)this.cells.get((int)cellIndex);
        if (!address.equals(cell.getKey())) {
            return Double.NaN;
        }
        return cell.getValue();
    }

    @Override
    public Iterator<Tensor.Cell> cellIterator() {
        return this.cells.iterator();
    }

    @Override
    public Iterator<Double> valueIterator() {
        return new Iterator<Double>(){
            Iterator<Tensor.Cell> cellIterator;
            {
                this.cellIterator = MixedTensor.this.cellIterator();
            }

            @Override
            public boolean hasNext() {
                return this.cellIterator.hasNext();
            }

            @Override
            public Double next() {
                return this.cellIterator.next().getValue();
            }
        };
    }

    @Override
    public Map<TensorAddress, Double> cells() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Tensor.Cell cell : this.cells) {
            builder.put((Object)cell.getKey(), (Object)cell.getValue());
        }
        return builder.build();
    }

    @Override
    public Tensor withType(TensorType other) {
        if (!this.type.isRenamableTo(this.type)) {
            throw new IllegalArgumentException("MixedTensor.withType: types are not compatible. Current type: '" + this.type.toString() + "', requested type: '" + this.type.toString() + "'");
        }
        return new MixedTensor(other, this.cells, this.index);
    }

    @Override
    public Tensor remove(Set<TensorAddress> addresses) {
        Tensor.Builder builder = Tensor.Builder.of(this.type());
        for (Map.Entry entry : this.index.sparseMap.entrySet()) {
            TensorAddress sparsePartialAddress = (TensorAddress)entry.getKey();
            if (addresses.contains(sparsePartialAddress)) continue;
            long offset = (Long)entry.getValue();
            int i = 0;
            while ((long)i < this.index.denseSubspaceSize) {
                Tensor.Cell cell = (Tensor.Cell)this.cells.get((int)offset + i);
                builder.cell(cell.getKey(), (double)cell.getValue());
                ++i;
            }
        }
        return builder.build();
    }

    public int hashCode() {
        return this.cells.hashCode();
    }

    @Override
    public String toString() {
        if (this.type.rank() == 0) {
            return Tensor.toStandardString(this);
        }
        if (this.type.rank() > 1 && this.type.dimensions().stream().filter(d -> d.isIndexed()).anyMatch(d -> d.size().isEmpty())) {
            return Tensor.toStandardString(this);
        }
        if (this.type.dimensions().stream().filter(d -> d.isMapped()).count() > 1L) {
            return Tensor.toStandardString(this);
        }
        return this.type.toString() + ":" + this.index.contentToString(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Tensor)) {
            return false;
        }
        return Tensor.equals(this, (Tensor)other);
    }

    public long denseSubspaceSize() {
        return this.index.denseSubspaceSize();
    }

    public static TensorType createPartialType(TensorType.Value valueType, List<TensorType.Dimension> dimensions) {
        TensorType.Builder builder = new TensorType.Builder(valueType);
        for (TensorType.Dimension dimension : dimensions) {
            builder.set(dimension);
        }
        return builder.build();
    }

    private static class DenseSubspaceBuilder
    implements IndexedTensor.DirectIndexBuilder {
        private final TensorType type;
        private final double[] values;

        public DenseSubspaceBuilder(TensorType type, double[] values) {
            this.type = type;
            this.values = values;
        }

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public void cellByDirectIndex(long index, double value) {
            this.values[(int)index] = value;
        }

        @Override
        public void cellByDirectIndex(long index, float value) {
            this.values[(int)index] = value;
        }
    }

    private static class Index {
        private final TensorType type;
        private final TensorType sparseType;
        private final TensorType denseType;
        private final List<TensorType.Dimension> mappedDimensions;
        private final List<TensorType.Dimension> indexedDimensions;
        private ImmutableMap<TensorAddress, Long> sparseMap;
        private long denseSubspaceSize = -1L;

        private Index(TensorType type) {
            this.type = type;
            this.mappedDimensions = type.dimensions().stream().filter(d -> !d.isIndexed()).collect(Collectors.toList());
            this.indexedDimensions = type.dimensions().stream().filter(d -> d.isIndexed()).collect(Collectors.toList());
            this.sparseType = MixedTensor.createPartialType(type.valueType(), this.mappedDimensions);
            this.denseType = MixedTensor.createPartialType(type.valueType(), this.indexedDimensions);
        }

        public long indexOf(TensorAddress address) {
            TensorAddress sparsePart = this.sparsePartialAddress(address);
            if (!this.sparseMap.containsKey((Object)sparsePart)) {
                return -1L;
            }
            long base = (Long)this.sparseMap.get((Object)sparsePart);
            long offset = this.denseOffset(address);
            return base + offset;
        }

        public long denseSubspaceSize() {
            if (this.denseSubspaceSize == -1L) {
                this.denseSubspaceSize = 1L;
                for (int i = 0; i < this.type.dimensions().size(); ++i) {
                    TensorType.Dimension dimension = this.type.dimensions().get(i);
                    if (!dimension.isIndexed()) continue;
                    this.denseSubspaceSize *= dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension")).longValue();
                }
            }
            return this.denseSubspaceSize;
        }

        private TensorAddress sparsePartialAddress(TensorAddress address) {
            if (this.type.dimensions().size() != address.size()) {
                throw new IllegalArgumentException("Tensor type of " + this + " is not the same size as " + address);
            }
            TensorAddress.Builder builder = new TensorAddress.Builder(this.sparseType);
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (dimension.isIndexed()) continue;
                builder.add(dimension.name(), address.label(i));
            }
            return builder.build();
        }

        private long denseOffset(TensorAddress address) {
            long innerSize = 1L;
            long offset = 0L;
            int i = this.type.dimensions().size();
            while (--i >= 0) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) continue;
                long label = address.numericLabel(i);
                offset += label * innerSize;
                innerSize *= dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension.")).longValue();
            }
            return offset;
        }

        private TensorAddress denseOffsetToAddress(long denseOffset) {
            if (denseOffset < 0L || denseOffset > this.denseSubspaceSize) {
                throw new IllegalArgumentException("Offset out of bounds");
            }
            long restSize = denseOffset;
            long innerSize = this.denseSubspaceSize;
            long[] labels = new long[this.indexedDimensions.size()];
            for (int i = 0; i < labels.length; ++i) {
                TensorType.Dimension dimension = this.indexedDimensions.get(i);
                long dimensionSize = dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension."));
                labels[i] = restSize / (innerSize /= dimensionSize);
                restSize %= innerSize;
            }
            return TensorAddress.of(labels);
        }

        private TensorAddress addressOf(TensorAddress sparsePart, long denseOffset) {
            TensorAddress densePart = this.denseOffsetToAddress(denseOffset);
            String[] labels = new String[this.type.dimensions().size()];
            int mappedIndex = 0;
            int indexedIndex = 0;
            for (TensorType.Dimension d : this.type.dimensions()) {
                if (d.isIndexed()) {
                    labels[mappedIndex + indexedIndex] = densePart.label(indexedIndex);
                    ++indexedIndex;
                    continue;
                }
                labels[mappedIndex + indexedIndex] = sparsePart.label(mappedIndex);
                ++mappedIndex;
            }
            return TensorAddress.of(labels);
        }

        public String toString() {
            return "index into " + this.type;
        }

        private String contentToString(MixedTensor tensor) {
            if (this.mappedDimensions.size() > 1) {
                throw new IllegalStateException("Should be ensured by caller");
            }
            if (this.mappedDimensions.size() == 0) {
                StringBuilder b = new StringBuilder();
                this.denseSubspaceToString(tensor, 0L, b);
                return b.toString();
            }
            StringBuilder b = new StringBuilder("{");
            this.sparseMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                b.append(TensorAddress.labelToString(((TensorAddress)entry.getKey()).label(0)));
                b.append(":");
                this.denseSubspaceToString(tensor, (Long)entry.getValue(), b);
                b.append(",");
            });
            if (b.length() > 1) {
                b.setLength(b.length() - 1);
            }
            b.append("}");
            return b.toString();
        }

        private void denseSubspaceToString(MixedTensor tensor, long subspaceIndex, StringBuilder b) {
            if (this.denseSubspaceSize == 1L) {
                b.append(this.getDouble(subspaceIndex, 0L, tensor));
                return;
            }
            IndexedTensor.Indexes indexes = IndexedTensor.Indexes.of(this.denseType);
            int index = 0;
            while ((long)index < this.denseSubspaceSize) {
                int i;
                indexes.next();
                for (i = 0; i < indexes.nextDimensionsAtStart(); ++i) {
                    b.append("[");
                }
                switch (this.type.valueType()) {
                    case DOUBLE: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case FLOAT: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case BFLOAT16: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case INT8: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value type " + this.type.valueType());
                    }
                }
                for (i = 0; i < indexes.nextDimensionsAtEnd(); ++i) {
                    b.append("]");
                }
                if ((long)index < this.denseSubspaceSize - 1L) {
                    b.append(", ");
                }
                ++index;
            }
        }

        private double getDouble(long indexedSubspaceIndex, long indexInIndexedSubspace, MixedTensor tensor) {
            return ((Tensor.Cell)tensor.cells.get((int)(indexedSubspaceIndex + indexInIndexedSubspace))).getDoubleValue();
        }

        public static class Builder {
            private final Index index;
            private final ImmutableMap.Builder<TensorAddress, Long> builder;

            public Builder(TensorType type) {
                this.index = new Index(type);
                this.builder = new ImmutableMap.Builder();
            }

            public void put(TensorAddress address, long index) {
                this.builder.put((Object)address, (Object)index);
            }

            public Index build() {
                this.index.sparseMap = this.builder.build();
                return this.index;
            }

            public Index index() {
                return this.index;
            }
        }
    }

    public static class UnboundBuilder
    extends Builder {
        private Map<TensorAddress, Double> cells = new HashMap<TensorAddress, Double>();
        private final long[] dimensionBounds;

        private UnboundBuilder(TensorType type) {
            super(type);
            this.dimensionBounds = new long[type.dimensions().size()];
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, double value) {
            this.cells.put(address, value);
            this.trackBounds(address);
            return this;
        }

        @Override
        public MixedTensor build() {
            TensorType boundType = this.createBoundType();
            BoundBuilder builder = new BoundBuilder(boundType);
            for (Map.Entry<TensorAddress, Double> cell : this.cells.entrySet()) {
                builder.cell(cell.getKey(), (double)cell.getValue());
            }
            return builder.build();
        }

        public void trackBounds(TensorAddress address) {
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) continue;
                this.dimensionBounds[i] = Math.max(address.numericLabel(i), this.dimensionBounds[i]);
            }
        }

        public TensorType createBoundType() {
            TensorType.Builder typeBuilder = new TensorType.Builder(this.type().valueType());
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) {
                    typeBuilder.mapped(dimension.name());
                    continue;
                }
                long size = dimension.size().orElse(this.dimensionBounds[i] + 1L);
                typeBuilder.indexed(dimension.name(), size);
            }
            return typeBuilder.build();
        }
    }

    public static class BoundBuilder
    extends Builder {
        private final Map<TensorAddress, double[]> denseSubspaceMap = new HashMap<TensorAddress, double[]>();
        private final Index.Builder indexBuilder;
        private final Index index;
        private final TensorType denseSubtype;

        private BoundBuilder(TensorType type) {
            super(type);
            this.indexBuilder = new Index.Builder(type);
            this.index = this.indexBuilder.index();
            this.denseSubtype = new TensorType(type.valueType(), type.dimensions().stream().filter(d -> d.isIndexed()).collect(Collectors.toList()));
        }

        public long denseSubspaceSize() {
            return this.index.denseSubspaceSize();
        }

        private double[] denseSubspace(TensorAddress sparseAddress) {
            if (!this.denseSubspaceMap.containsKey(sparseAddress)) {
                this.denseSubspaceMap.put(sparseAddress, new double[(int)this.denseSubspaceSize()]);
            }
            return this.denseSubspaceMap.get(sparseAddress);
        }

        public IndexedTensor.DirectIndexBuilder denseSubspaceBuilder(TensorAddress sparseAddress) {
            double[] values = new double[(int)this.denseSubspaceSize()];
            this.denseSubspaceMap.put(sparseAddress, values);
            return new DenseSubspaceBuilder(this.denseSubtype, values);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, double value) {
            TensorAddress sparsePart = this.index.sparsePartialAddress(address);
            long denseOffset = this.index.denseOffset(address);
            double[] denseSubspace = this.denseSubspace(sparsePart);
            denseSubspace[(int)denseOffset] = value;
            return this;
        }

        public Tensor.Builder block(TensorAddress sparsePart, double[] values) {
            int denseSubspaceSize = (int)this.denseSubspaceSize();
            if (values.length < denseSubspaceSize) {
                throw new IllegalArgumentException("Block should have " + denseSubspaceSize + " values, but has only " + values.length);
            }
            double[] denseSubspace = this.denseSubspace(sparsePart);
            System.arraycopy(values, 0, denseSubspace, 0, denseSubspaceSize);
            return this;
        }

        @Override
        public MixedTensor build() {
            long count = 0L;
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Map.Entry<TensorAddress, double[]> entry : this.denseSubspaceMap.entrySet()) {
                TensorAddress sparsePart = entry.getKey();
                this.indexBuilder.put(sparsePart, count);
                double[] denseSubspace = entry.getValue();
                for (long offset = 0L; offset < (long)denseSubspace.length; ++offset) {
                    TensorAddress cellAddress = this.index.addressOf(sparsePart, offset);
                    double value = denseSubspace[(int)offset];
                    builder.add((Object)new Tensor.Cell(cellAddress, value));
                    ++count;
                }
            }
            return new MixedTensor(this.type, (ImmutableList<Tensor.Cell>)builder.build(), this.indexBuilder.build());
        }
    }

    public static abstract class Builder
    implements Tensor.Builder {
        final TensorType type;

        public static Builder of(TensorType type) {
            if (type.dimensions().stream().anyMatch(d -> d instanceof TensorType.IndexedUnboundDimension)) {
                return new UnboundBuilder(type);
            }
            return new BoundBuilder(type);
        }

        private Builder(TensorType type) {
            this.type = type;
        }

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public Tensor.Builder cell(float value, long ... labels) {
            return this.cell((double)value, labels);
        }

        @Override
        public Tensor.Builder cell(double value, long ... labels) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type(), this);
        }

        @Override
        public abstract MixedTensor build();
    }
}

