/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.io.AbstractByteWriter;
import com.yahoo.io.ByteWriter;
import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeFormat;
import com.yahoo.slime.Utf8Codec;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8String;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public final class JsonFormat
implements SlimeFormat {
    private static final byte[] HEX = Utf8.toBytes("0123456789ABCDEF");
    private final boolean compact;

    public JsonFormat(boolean compact) {
        this.compact = compact;
    }

    @Override
    public void encode(OutputStream os, Slime slime) throws IOException {
        new Encoder((Inspector)slime.get(), os, this.compact).encode();
    }

    public void encode(OutputStream os, Inspector value) throws IOException {
        new Encoder(value, os, this.compact).encode();
    }

    public void encode(AbstractByteWriter os, Slime slime) throws IOException {
        new Encoder((Inspector)slime.get(), os, this.compact).encode();
    }

    public void encode(AbstractByteWriter os, Inspector value) throws IOException {
        new Encoder(value, os, this.compact).encode();
    }

    @Override
    public void decode(InputStream is, Slime slime) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static byte[] toJsonBytes(Slime slime) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new JsonFormat(true).encode((OutputStream)baos, slime);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Slime jsonToSlime(byte[] json) {
        Slime slime = new Slime();
        new JsonDecoder().decode(slime, json);
        return slime;
    }

    public static final class Encoder
    implements ArrayTraverser,
    ObjectTraverser {
        private final Inspector top;
        private final AbstractByteWriter out;
        private boolean head = true;
        private boolean compact;
        private int level = 0;
        static final AbstractUtf8Array NULL = new Utf8String("null");
        static final AbstractUtf8Array FALSE = new Utf8String("false");
        static final AbstractUtf8Array TRUE = new Utf8String("true");

        public Encoder(Inspector value, OutputStream out, boolean compact) {
            this.top = value;
            this.out = new ByteWriter(out);
            this.compact = compact;
        }

        public Encoder(Inspector value, AbstractByteWriter out, boolean compact) {
            this.top = value;
            this.out = out;
            this.compact = compact;
        }

        public void encode() throws IOException {
            this.encodeValue(this.top);
            if (!this.compact) {
                this.out.append((byte)10);
            }
            this.out.flush();
        }

        private void encodeNIX() throws IOException {
            this.out.write(NULL);
        }

        private void encodeBOOL(boolean value) throws IOException {
            this.out.write(value ? TRUE : FALSE);
        }

        private void encodeLONG(long value) throws IOException {
            this.out.write(value);
        }

        private void encodeDOUBLE(double value) throws IOException {
            if (Double.isFinite(value)) {
                this.out.write(String.valueOf(value));
            } else {
                this.out.write(NULL);
            }
        }

        private void encodeSTRING(byte[] value) throws IOException {
            byte[] data = new byte[value.length * 6 + 2];
            int len = 2;
            int p = 0;
            data[p++] = 34;
            block9: for (int pos = 0; pos < value.length; ++pos) {
                byte c = value[pos];
                switch (c) {
                    case 34: {
                        data[p++] = 92;
                        data[p++] = 34;
                        len += 2;
                        continue block9;
                    }
                    case 92: {
                        data[p++] = 92;
                        data[p++] = 92;
                        len += 2;
                        continue block9;
                    }
                    case 8: {
                        data[p++] = 92;
                        data[p++] = 98;
                        len += 2;
                        continue block9;
                    }
                    case 12: {
                        data[p++] = 92;
                        data[p++] = 102;
                        len += 2;
                        continue block9;
                    }
                    case 10: {
                        data[p++] = 92;
                        data[p++] = 110;
                        len += 2;
                        continue block9;
                    }
                    case 13: {
                        data[p++] = 92;
                        data[p++] = 114;
                        len += 2;
                        continue block9;
                    }
                    case 9: {
                        data[p++] = 92;
                        data[p++] = 116;
                        len += 2;
                        continue block9;
                    }
                    default: {
                        if (c > 31 || c < 0) {
                            data[p++] = c;
                            ++len;
                            continue block9;
                        }
                        data[p++] = 92;
                        data[p++] = 117;
                        data[p++] = 48;
                        data[p++] = 48;
                        data[p++] = HEX[c >> 4 & 0xF];
                        data[p++] = HEX[c & 0xF];
                        len += 6;
                    }
                }
            }
            data[p] = 34;
            this.out.append(data, 0, len);
        }

        private void encodeDATA(byte[] value) throws IOException {
            int len = value.length * 2 + 4;
            byte[] data = new byte[len];
            int p = 0;
            data[p++] = 34;
            data[p++] = 48;
            data[p++] = 120;
            for (int pos = 0; pos < value.length; ++pos) {
                data[p++] = HEX[value[pos] >> 4 & 0xF];
                data[p++] = HEX[value[pos] & 0xF];
            }
            data[p] = 34;
            this.out.append(data, 0, len);
        }

        private void encodeARRAY(Inspector inspector) throws IOException {
            this.openScope((byte)91);
            Encoder at = this;
            inspector.traverse(at);
            this.closeScope((byte)93);
        }

        private void encodeOBJECT(Inspector inspector) throws IOException {
            this.openScope((byte)123);
            Encoder ot = this;
            inspector.traverse(ot);
            this.closeScope((byte)125);
        }

        private void openScope(byte opener) throws IOException {
            this.out.append(opener);
            ++this.level;
            this.head = true;
        }

        private void closeScope(byte closer) throws IOException {
            --this.level;
            this.separate(false);
            this.out.append(closer);
        }

        private void encodeValue(Inspector inspector) throws IOException {
            switch (inspector.type()) {
                case NIX: {
                    this.encodeNIX();
                    return;
                }
                case BOOL: {
                    this.encodeBOOL(inspector.asBool());
                    return;
                }
                case LONG: {
                    this.encodeLONG(inspector.asLong());
                    return;
                }
                case DOUBLE: {
                    this.encodeDOUBLE(inspector.asDouble());
                    return;
                }
                case STRING: {
                    this.encodeSTRING(inspector.asUtf8());
                    return;
                }
                case DATA: {
                    this.encodeDATA(inspector.asData());
                    return;
                }
                case ARRAY: {
                    this.encodeARRAY(inspector);
                    return;
                }
                case OBJECT: {
                    this.encodeOBJECT(inspector);
                    return;
                }
            }
            assert (false) : "Should not be reached";
        }

        private void separate(boolean useComma) throws IOException {
            if (!this.head && useComma) {
                this.out.append((byte)44);
            } else {
                this.head = false;
            }
            if (!this.compact) {
                this.out.append((byte)10);
                for (int lvl = 0; lvl < this.level; ++lvl) {
                    this.out.append((byte)32);
                }
            }
        }

        @Override
        public void entry(int idx, Inspector inspector) {
            try {
                this.separate(true);
                this.encodeValue(inspector);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void field(String name, Inspector inspector) {
            try {
                this.separate(true);
                this.encodeSTRING(Utf8Codec.encode(name));
                this.out.append((byte)58);
                if (!this.compact) {
                    this.out.append((byte)32);
                }
                this.encodeValue(inspector);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

