/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayValue;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.NixValue;
import com.yahoo.slime.ObjectSymbolTraverser;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.SymbolTable;
import com.yahoo.slime.Type;
import com.yahoo.slime.Value;
import com.yahoo.slime.Visitor;

final class ObjectValue
extends Value {
    private int capacity = 16;
    private int used = 0;
    private Value[] values = new Value[this.capacity];
    private int[] hash = new int[this.capacity + this.hashSize() + (this.capacity << 1)];
    private final SymbolTable names;

    private int hashSize() {
        return this.capacity + (this.capacity >> 1) - 1;
    }

    private final void rehash() {
        this.capacity <<= 1;
        Value[] v = this.values;
        this.values = new Value[this.capacity];
        System.arraycopy(v, 0, this.values, 0, this.used);
        int[] h = this.hash;
        this.hash = new int[this.capacity + this.hashSize() + (this.capacity << 1)];
        System.arraycopy(h, 0, this.hash, 0, this.used);
        int i = 0;
        while (i < this.used) {
            int insertIdx;
            int prev = this.capacity + this.hash[i] % this.hashSize();
            int entry = this.hash[prev];
            while (entry != 0) {
                prev = entry + 1;
                entry = this.hash[prev];
            }
            this.hash[prev] = insertIdx = this.capacity + this.hashSize() + (i << 1);
            this.hash[insertIdx] = i++;
        }
    }

    private final Value put(int sym, Value value) {
        int insertIdx;
        if (this.used == this.capacity) {
            this.rehash();
        }
        int prev = this.capacity + sym % this.hashSize();
        int entry = this.hash[prev];
        while (entry != 0) {
            int idx = this.hash[entry];
            if (this.hash[idx] == sym) {
                return NixValue.invalid();
            }
            prev = entry + 1;
            entry = this.hash[prev];
        }
        this.hash[prev] = insertIdx = this.capacity + this.hashSize() + (this.used << 1);
        this.hash[insertIdx] = this.used;
        this.hash[this.used] = sym;
        this.values[this.used++] = value;
        return value;
    }

    private final Value get(int sym) {
        int entry = this.hash[this.capacity + sym % this.hashSize()];
        while (entry != 0) {
            int idx = this.hash[entry];
            if (this.hash[idx] == sym) {
                return this.values[idx];
            }
            entry = this.hash[entry + 1];
        }
        return NixValue.invalid();
    }

    public ObjectValue(SymbolTable names) {
        this.names = names;
    }

    public ObjectValue(SymbolTable names, int sym, Value value) {
        this.names = names;
        this.put(sym, value);
    }

    @Override
    public final Type type() {
        return Type.OBJECT;
    }

    @Override
    public final int children() {
        return this.used;
    }

    @Override
    public final int fields() {
        return this.used;
    }

    @Override
    public final Value field(int sym) {
        return this.get(sym);
    }

    @Override
    public final Value field(String name) {
        return this.get(this.names.lookup(name));
    }

    @Override
    public final void accept(Visitor v) {
        v.visitObject(this);
    }

    @Override
    public final void traverse(ObjectSymbolTraverser ot) {
        for (int i = 0; i < this.used; ++i) {
            ot.field(this.hash[i], this.values[i]);
        }
    }

    @Override
    public final void traverse(ObjectTraverser ot) {
        for (int i = 0; i < this.used; ++i) {
            ot.field(this.names.inspect(this.hash[i]), this.values[i]);
        }
    }

    @Override
    protected final Cursor setLeaf(int sym, Value value) {
        return this.put(sym, value);
    }

    @Override
    public final Cursor setArray(int sym) {
        return this.put(sym, new ArrayValue(this.names));
    }

    @Override
    public final Cursor setObject(int sym) {
        return this.put(sym, new ObjectValue(this.names));
    }

    @Override
    protected final Cursor setLeaf(String name, Value value) {
        return this.put(this.names.insert(name), value);
    }

    @Override
    public final Cursor setArray(String name) {
        return this.put(this.names.insert(name), new ArrayValue(this.names));
    }

    @Override
    public final Cursor setObject(String name) {
        return this.put(this.names.insert(name), new ObjectValue(this.names));
    }
}

